<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryScanDetails TrackingService
 * Meta information extracted from the WSDL
 * - documentation: DeliveryScanDetails
 * - nillable: true
 * - type: tns:DeliveryScanDetails
 * @subpackage Structs
 */
class DeliveryScanDetails extends AbstractStructBase
{
    /**
     * The DeliverySignature
     * Meta information extracted from the WSDL
     * - documentation: DeliverySignature - string
     * - nillable: true
     * @var string
     */
    public $DeliverySignature;
    /**
     * The SignatureImage
     * Meta information extracted from the WSDL
     * - documentation: SignatureImage - string
     * - nillable: true
     * @var string
     */
    public $SignatureImage;
    /**
     * The SignatureImageSize
     * Meta information extracted from the WSDL
     * - documentation: SignatureImageSize - int
     * @var int
     */
    public $SignatureImageSize;
    /**
     * The SignatureImageFormat
     * Meta information extracted from the WSDL
     * - documentation: SignatureImageFormat - SignatureImageFormat
     * @var string
     */
    public $SignatureImageFormat;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - documentation: DeliveryAddress - string
     * - nillable: true
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The DeliveryCompanyName
     * Meta information extracted from the WSDL
     * - documentation: DeliveryCompanyName - string
     * - nillable: true
     * @var string
     */
    public $DeliveryCompanyName;
    /**
     * The PremiumServiceText
     * Meta information extracted from the WSDL
     * - documentation: PremiumServiceText - string
     * - nillable: true
     * @var string
     */
    public $PremiumServiceText;
    /**
     * The ProductTypeText
     * Meta information extracted from the WSDL
     * - documentation: ProductTypeText - string
     * - nillable: true
     * @var string
     */
    public $ProductTypeText;
    /**
     * The SpecialHandlingText
     * Meta information extracted from the WSDL
     * - documentation: SpecialHandlingText - string
     * - nillable: true
     * @var string
     */
    public $SpecialHandlingText;
    /**
     * The PaymentTypeText
     * Meta information extracted from the WSDL
     * - documentation: PaymentTypeText - string
     * - nillable: true
     * @var string
     */
    public $PaymentTypeText;
    /**
     * Constructor method for DeliveryScanDetails
     * @uses DeliveryScanDetails::setDeliverySignature()
     * @uses DeliveryScanDetails::setSignatureImage()
     * @uses DeliveryScanDetails::setSignatureImageSize()
     * @uses DeliveryScanDetails::setSignatureImageFormat()
     * @uses DeliveryScanDetails::setDeliveryAddress()
     * @uses DeliveryScanDetails::setDeliveryCompanyName()
     * @uses DeliveryScanDetails::setPremiumServiceText()
     * @uses DeliveryScanDetails::setProductTypeText()
     * @uses DeliveryScanDetails::setSpecialHandlingText()
     * @uses DeliveryScanDetails::setPaymentTypeText()
     * @param string $deliverySignature
     * @param string $signatureImage
     * @param int $signatureImageSize
     * @param string $signatureImageFormat
     * @param string $deliveryAddress
     * @param string $deliveryCompanyName
     * @param string $premiumServiceText
     * @param string $productTypeText
     * @param string $specialHandlingText
     * @param string $paymentTypeText
     */
    public function __construct($deliverySignature = null, $signatureImage = null, $signatureImageSize = null, $signatureImageFormat = null, $deliveryAddress = null, $deliveryCompanyName = null, $premiumServiceText = null, $productTypeText = null, $specialHandlingText = null, $paymentTypeText = null)
    {
        $this
            ->setDeliverySignature($deliverySignature)
            ->setSignatureImage($signatureImage)
            ->setSignatureImageSize($signatureImageSize)
            ->setSignatureImageFormat($signatureImageFormat)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryCompanyName($deliveryCompanyName)
            ->setPremiumServiceText($premiumServiceText)
            ->setProductTypeText($productTypeText)
            ->setSpecialHandlingText($specialHandlingText)
            ->setPaymentTypeText($paymentTypeText);
    }
    /**
     * Get DeliverySignature value
     * @return string|null
     */
    public function getDeliverySignature()
    {
        return $this->DeliverySignature;
    }
    /**
     * Set DeliverySignature value
     * @param string $deliverySignature
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setDeliverySignature($deliverySignature = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySignature) && !is_string($deliverySignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySignature, true), gettype($deliverySignature)), __LINE__);
        }
        $this->DeliverySignature = $deliverySignature;
        return $this;
    }
    /**
     * Get SignatureImage value
     * @return string|null
     */
    public function getSignatureImage()
    {
        return $this->SignatureImage;
    }
    /**
     * Set SignatureImage value
     * @param string $signatureImage
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setSignatureImage($signatureImage = null)
    {
        // validation for constraint: string
        if (!is_null($signatureImage) && !is_string($signatureImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureImage, true), gettype($signatureImage)), __LINE__);
        }
        $this->SignatureImage = $signatureImage;
        return $this;
    }
    /**
     * Get SignatureImageSize value
     * @return int|null
     */
    public function getSignatureImageSize()
    {
        return $this->SignatureImageSize;
    }
    /**
     * Set SignatureImageSize value
     * @param int $signatureImageSize
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setSignatureImageSize($signatureImageSize = null)
    {
        // validation for constraint: int
        if (!is_null($signatureImageSize) && !(is_int($signatureImageSize) || ctype_digit($signatureImageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($signatureImageSize, true), gettype($signatureImageSize)), __LINE__);
        }
        $this->SignatureImageSize = $signatureImageSize;
        return $this;
    }
    /**
     * Get SignatureImageFormat value
     * @return string|null
     */
    public function getSignatureImageFormat()
    {
        return $this->SignatureImageFormat;
    }
    /**
     * Set SignatureImageFormat value
     * @uses \Pepitelabs\PWS\TrackingService\SignatureImageFormat::valueIsValid()
     * @uses \Pepitelabs\PWS\TrackingService\SignatureImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $signatureImageFormat
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setSignatureImageFormat($signatureImageFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\TrackingService\SignatureImageFormat::valueIsValid($signatureImageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\TrackingService\SignatureImageFormat', is_array($signatureImageFormat) ? implode(', ', $signatureImageFormat) : var_export($signatureImageFormat, true), implode(', ', \Pepitelabs\PWS\TrackingService\SignatureImageFormat::getValidValues())), __LINE__);
        }
        $this->SignatureImageFormat = $signatureImageFormat;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param string $deliveryAddress
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get DeliveryCompanyName value
     * @return string|null
     */
    public function getDeliveryCompanyName()
    {
        return $this->DeliveryCompanyName;
    }
    /**
     * Set DeliveryCompanyName value
     * @param string $deliveryCompanyName
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setDeliveryCompanyName($deliveryCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCompanyName) && !is_string($deliveryCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCompanyName, true), gettype($deliveryCompanyName)), __LINE__);
        }
        $this->DeliveryCompanyName = $deliveryCompanyName;
        return $this;
    }
    /**
     * Get PremiumServiceText value
     * @return string|null
     */
    public function getPremiumServiceText()
    {
        return $this->PremiumServiceText;
    }
    /**
     * Set PremiumServiceText value
     * @param string $premiumServiceText
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setPremiumServiceText($premiumServiceText = null)
    {
        // validation for constraint: string
        if (!is_null($premiumServiceText) && !is_string($premiumServiceText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumServiceText, true), gettype($premiumServiceText)), __LINE__);
        }
        $this->PremiumServiceText = $premiumServiceText;
        return $this;
    }
    /**
     * Get ProductTypeText value
     * @return string|null
     */
    public function getProductTypeText()
    {
        return $this->ProductTypeText;
    }
    /**
     * Set ProductTypeText value
     * @param string $productTypeText
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setProductTypeText($productTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($productTypeText) && !is_string($productTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTypeText, true), gettype($productTypeText)), __LINE__);
        }
        $this->ProductTypeText = $productTypeText;
        return $this;
    }
    /**
     * Get SpecialHandlingText value
     * @return string|null
     */
    public function getSpecialHandlingText()
    {
        return $this->SpecialHandlingText;
    }
    /**
     * Set SpecialHandlingText value
     * @param string $specialHandlingText
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setSpecialHandlingText($specialHandlingText = null)
    {
        // validation for constraint: string
        if (!is_null($specialHandlingText) && !is_string($specialHandlingText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialHandlingText, true), gettype($specialHandlingText)), __LINE__);
        }
        $this->SpecialHandlingText = $specialHandlingText;
        return $this;
    }
    /**
     * Get PaymentTypeText value
     * @return string|null
     */
    public function getPaymentTypeText()
    {
        return $this->PaymentTypeText;
    }
    /**
     * Set PaymentTypeText value
     * @param string $paymentTypeText
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public function setPaymentTypeText($paymentTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeText) && !is_string($paymentTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeText, true), gettype($paymentTypeText)), __LINE__);
        }
        $this->PaymentTypeText = $paymentTypeText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\DeliveryScanDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
