<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pepitelabs\PWS\ClassMap::get(),
);
/**
 * Samples for Track ServiceType
 */
$track = new \Pepitelabs\PWS\TrackingService\Track($options);
$track->setSoapHeaderRequestContext(new \Pepitelabs\PWS\TrackingService\RequestContext());
/**
 * Sample call for TrackPackagesByPin operation/method
 */
if ($track->TrackPackagesByPin(new \Pepitelabs\PWS\TrackingService\TrackPackagesByPinRequestContainer()) !== false) {
    print_r($track->getResult());
} else {
    print_r($track->getLastError());
}
/**
 * Sample call for TrackPackagesByReference operation/method
 */
if ($track->TrackPackagesByReference(new \Pepitelabs\PWS\TrackingService\TrackPackagesByReferenceRequestContainer()) !== false) {
    print_r($track->getResult());
} else {
    print_r($track->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Pepitelabs\PWS\TrackingService\Get($options);
$get->setSoapHeaderRequestContext(new \Pepitelabs\PWS\TrackingService\RequestContext());
/**
 * Sample call for GetDeliveryDetails operation/method
 */
if ($get->GetDeliveryDetails(new \Pepitelabs\PWS\TrackingService\GetDeliveryDetailsRequestContainer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
