<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackPackageByReferenceSearchCriteria TrackingService
 * Meta information extracted from the WSDL
 * - documentation: TrackPackageByReferenceSearchCriteria
 * - nillable: true
 * - type: tns:TrackPackageByReferenceSearchCriteria
 * @subpackage Structs
 */
class TrackPackageByReferenceSearchCriteria extends AbstractStructBase
{
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The DestinationPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Reference
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationPostalCode;
    /**
     * The DestinationCountryCode
     * Meta information extracted from the WSDL
     * - documentation: DestinationCountryCode
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCountryCode;
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The ShipmentFromDate
     * Meta information extracted from the WSDL
     * - documentation: ShipmentFromDate
     * - nillable: true
     * @var string
     */
    public $ShipmentFromDate;
    /**
     * The ShipmentToDate
     * Meta information extracted from the WSDL
     * - documentation: ShipmentToDate
     * - nillable: true
     * @var string
     */
    public $ShipmentToDate;
    /**
     * Constructor method for TrackPackageByReferenceSearchCriteria
     * @uses TrackPackageByReferenceSearchCriteria::setReference()
     * @uses TrackPackageByReferenceSearchCriteria::setDestinationPostalCode()
     * @uses TrackPackageByReferenceSearchCriteria::setDestinationCountryCode()
     * @uses TrackPackageByReferenceSearchCriteria::setBillingAccountNumber()
     * @uses TrackPackageByReferenceSearchCriteria::setShipmentFromDate()
     * @uses TrackPackageByReferenceSearchCriteria::setShipmentToDate()
     * @param string $reference
     * @param string $destinationPostalCode
     * @param string $destinationCountryCode
     * @param string $billingAccountNumber
     * @param string $shipmentFromDate
     * @param string $shipmentToDate
     */
    public function __construct($reference = null, $destinationPostalCode = null, $destinationCountryCode = null, $billingAccountNumber = null, $shipmentFromDate = null, $shipmentToDate = null)
    {
        $this
            ->setReference($reference)
            ->setDestinationPostalCode($destinationPostalCode)
            ->setDestinationCountryCode($destinationCountryCode)
            ->setBillingAccountNumber($billingAccountNumber)
            ->setShipmentFromDate($shipmentFromDate)
            ->setShipmentToDate($shipmentToDate);
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get DestinationPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationPostalCode()
    {
        return isset($this->DestinationPostalCode) ? $this->DestinationPostalCode : null;
    }
    /**
     * Set DestinationPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationPostalCode
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setDestinationPostalCode($destinationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPostalCode) && !is_string($destinationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPostalCode, true), gettype($destinationPostalCode)), __LINE__);
        }
        if (is_null($destinationPostalCode) || (is_array($destinationPostalCode) && empty($destinationPostalCode))) {
            unset($this->DestinationPostalCode);
        } else {
            $this->DestinationPostalCode = $destinationPostalCode;
        }
        return $this;
    }
    /**
     * Get DestinationCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCountryCode()
    {
        return isset($this->DestinationCountryCode) ? $this->DestinationCountryCode : null;
    }
    /**
     * Set DestinationCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCountryCode
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setDestinationCountryCode($destinationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountryCode) && !is_string($destinationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountryCode, true), gettype($destinationCountryCode)), __LINE__);
        }
        if (is_null($destinationCountryCode) || (is_array($destinationCountryCode) && empty($destinationCountryCode))) {
            unset($this->DestinationCountryCode);
        } else {
            $this->DestinationCountryCode = $destinationCountryCode;
        }
        return $this;
    }
    /**
     * Get BillingAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return isset($this->BillingAccountNumber) ? $this->BillingAccountNumber : null;
    }
    /**
     * Set BillingAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        if (is_null($billingAccountNumber) || (is_array($billingAccountNumber) && empty($billingAccountNumber))) {
            unset($this->BillingAccountNumber);
        } else {
            $this->BillingAccountNumber = $billingAccountNumber;
        }
        return $this;
    }
    /**
     * Get ShipmentFromDate value
     * @return string|null
     */
    public function getShipmentFromDate()
    {
        return $this->ShipmentFromDate;
    }
    /**
     * Set ShipmentFromDate value
     * @param string $shipmentFromDate
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setShipmentFromDate($shipmentFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentFromDate) && !is_string($shipmentFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentFromDate, true), gettype($shipmentFromDate)), __LINE__);
        }
        $this->ShipmentFromDate = $shipmentFromDate;
        return $this;
    }
    /**
     * Get ShipmentToDate value
     * @return string|null
     */
    public function getShipmentToDate()
    {
        return $this->ShipmentToDate;
    }
    /**
     * Set ShipmentToDate value
     * @param string $shipmentToDate
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public function setShipmentToDate($shipmentToDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentToDate) && !is_string($shipmentToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentToDate, true), gettype($shipmentToDate)), __LINE__);
        }
        $this->ShipmentToDate = $shipmentToDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\TrackPackageByReferenceSearchCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
