<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track TrackingService
 * @subpackage Services
 */
class Track extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\TrackingService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\TrackingService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named TrackPackagesByPin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\TrackingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: Track Packages By Pin @param request TrackPackagesByPinRequest @return TrackPackagesByPinResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\TrackingService\TrackPackagesByPinRequestContainer $trackPackagesByPinRequest
     * @return \Pepitelabs\PWS\TrackingService\TrackPackagesByPinResponseContainer|bool
     */
    public function TrackPackagesByPin(\Pepitelabs\PWS\TrackingService\TrackPackagesByPinRequestContainer $trackPackagesByPinRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackPackagesByPin($trackPackagesByPinRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrackPackagesByReference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\TrackingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: TrackPackagesByReference @param request TrackPackagesByReferenceRequest @return TrackPackagesByReferenceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\TrackingService\TrackPackagesByReferenceRequestContainer $trackPackagesByReferenceRequest
     * @return \Pepitelabs\PWS\TrackingService\TrackPackagesByReferenceResponseContainer|bool
     */
    public function TrackPackagesByReference(\Pepitelabs\PWS\TrackingService\TrackPackagesByReferenceRequestContainer $trackPackagesByReferenceRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackPackagesByReference($trackPackagesByReferenceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\TrackingService\TrackPackagesByPinResponseContainer|\Pepitelabs\PWS\TrackingService\TrackPackagesByReferenceResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
