<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatePickUpResponseContainer PickUpService
 * Meta information extracted from the WSDL
 * - documentation: ValidatePickUpRespone
 * - nillable: true
 * - type: tns:ValidatePickUpResponseContainer
 * @subpackage Structs
 */
class ValidatePickUpResponseContainer extends ResponseContainer
{
    /**
     * The IsBulkdRequired
     * Meta information extracted from the WSDL
     * - documentation: IsBulkdRequired - boolean
     * @var bool
     */
    public $IsBulkdRequired;
    /**
     * The CutOffTime
     * Meta information extracted from the WSDL
     * - documentation: CutOffTime - string
     * - nillable: true
     * @var string
     */
    public $CutOffTime;
    /**
     * The CutOffWindow
     * Meta information extracted from the WSDL
     * - documentation: CutOffWindow - int
     * @var int
     */
    public $CutOffWindow;
    /**
     * The BulkMaxWeight
     * Meta information extracted from the WSDL
     * - documentation: BulkMaxWeight - decimal
     * @var float
     */
    public $BulkMaxWeight;
    /**
     * The BulkMaxPackages
     * Meta information extracted from the WSDL
     * - documentation: BulkMaxPackages - int
     * @var int
     */
    public $BulkMaxPackages;
    /**
     * Constructor method for ValidatePickUpResponseContainer
     * @uses ValidatePickUpResponseContainer::setIsBulkdRequired()
     * @uses ValidatePickUpResponseContainer::setCutOffTime()
     * @uses ValidatePickUpResponseContainer::setCutOffWindow()
     * @uses ValidatePickUpResponseContainer::setBulkMaxWeight()
     * @uses ValidatePickUpResponseContainer::setBulkMaxPackages()
     * @param bool $isBulkdRequired
     * @param string $cutOffTime
     * @param int $cutOffWindow
     * @param float $bulkMaxWeight
     * @param int $bulkMaxPackages
     */
    public function __construct($isBulkdRequired = null, $cutOffTime = null, $cutOffWindow = null, $bulkMaxWeight = null, $bulkMaxPackages = null)
    {
        $this
            ->setIsBulkdRequired($isBulkdRequired)
            ->setCutOffTime($cutOffTime)
            ->setCutOffWindow($cutOffWindow)
            ->setBulkMaxWeight($bulkMaxWeight)
            ->setBulkMaxPackages($bulkMaxPackages);
    }
    /**
     * Get IsBulkdRequired value
     * @return bool|null
     */
    public function getIsBulkdRequired()
    {
        return $this->IsBulkdRequired;
    }
    /**
     * Set IsBulkdRequired value
     * @param bool $isBulkdRequired
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public function setIsBulkdRequired($isBulkdRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBulkdRequired) && !is_bool($isBulkdRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBulkdRequired, true), gettype($isBulkdRequired)), __LINE__);
        }
        $this->IsBulkdRequired = $isBulkdRequired;
        return $this;
    }
    /**
     * Get CutOffTime value
     * @return string|null
     */
    public function getCutOffTime()
    {
        return $this->CutOffTime;
    }
    /**
     * Set CutOffTime value
     * @param string $cutOffTime
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public function setCutOffTime($cutOffTime = null)
    {
        // validation for constraint: string
        if (!is_null($cutOffTime) && !is_string($cutOffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutOffTime, true), gettype($cutOffTime)), __LINE__);
        }
        $this->CutOffTime = $cutOffTime;
        return $this;
    }
    /**
     * Get CutOffWindow value
     * @return int|null
     */
    public function getCutOffWindow()
    {
        return $this->CutOffWindow;
    }
    /**
     * Set CutOffWindow value
     * @param int $cutOffWindow
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public function setCutOffWindow($cutOffWindow = null)
    {
        // validation for constraint: int
        if (!is_null($cutOffWindow) && !(is_int($cutOffWindow) || ctype_digit($cutOffWindow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cutOffWindow, true), gettype($cutOffWindow)), __LINE__);
        }
        $this->CutOffWindow = $cutOffWindow;
        return $this;
    }
    /**
     * Get BulkMaxWeight value
     * @return float|null
     */
    public function getBulkMaxWeight()
    {
        return $this->BulkMaxWeight;
    }
    /**
     * Set BulkMaxWeight value
     * @param float $bulkMaxWeight
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public function setBulkMaxWeight($bulkMaxWeight = null)
    {
        // validation for constraint: float
        if (!is_null($bulkMaxWeight) && !(is_float($bulkMaxWeight) || is_numeric($bulkMaxWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bulkMaxWeight, true), gettype($bulkMaxWeight)), __LINE__);
        }
        $this->BulkMaxWeight = $bulkMaxWeight;
        return $this;
    }
    /**
     * Get BulkMaxPackages value
     * @return int|null
     */
    public function getBulkMaxPackages()
    {
        return $this->BulkMaxPackages;
    }
    /**
     * Set BulkMaxPackages value
     * @param int $bulkMaxPackages
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public function setBulkMaxPackages($bulkMaxPackages = null)
    {
        // validation for constraint: int
        if (!is_null($bulkMaxPackages) && !(is_int($bulkMaxPackages) || ctype_digit($bulkMaxPackages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bulkMaxPackages, true), gettype($bulkMaxPackages)), __LINE__);
        }
        $this->BulkMaxPackages = $bulkMaxPackages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
