<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentSummaryDetail PickUpService
 * Meta information extracted from the WSDL
 * - documentation: Shipment Summary
 * - nillable: true
 * - type: tns:ShipmentSummaryDetail
 * @subpackage Structs
 */
class ShipmentSummaryDetail extends AbstractStructBase
{
    /**
     * The DestinationCode
     * Meta information extracted from the WSDL
     * - documentation: String - DestinationCode
     * - nillable: true
     * @var string
     */
    public $DestinationCode;
    /**
     * The ModeOfTransport
     * Meta information extracted from the WSDL
     * - documentation: String - ModeOfTransport
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModeOfTransport;
    /**
     * The TotalPieces
     * Meta information extracted from the WSDL
     * - documentation: Weight - TotalWeight
     * @var int
     */
    public $TotalPieces;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - documentation: Int - TotalPieces
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\Weight
     */
    public $TotalWeight;
    /**
     * Constructor method for ShipmentSummaryDetail
     * @uses ShipmentSummaryDetail::setDestinationCode()
     * @uses ShipmentSummaryDetail::setModeOfTransport()
     * @uses ShipmentSummaryDetail::setTotalPieces()
     * @uses ShipmentSummaryDetail::setTotalWeight()
     * @param string $destinationCode
     * @param string $modeOfTransport
     * @param int $totalPieces
     * @param \Pepitelabs\PWS\PickUpService\Weight $totalWeight
     */
    public function __construct($destinationCode = null, $modeOfTransport = null, $totalPieces = null, \Pepitelabs\PWS\PickUpService\Weight $totalWeight = null)
    {
        $this
            ->setDestinationCode($destinationCode)
            ->setModeOfTransport($modeOfTransport)
            ->setTotalPieces($totalPieces)
            ->setTotalWeight($totalWeight);
    }
    /**
     * Get DestinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }
    /**
     * Set DestinationCode value
     * @param string $destinationCode
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummaryDetail
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCode, true), gettype($destinationCode)), __LINE__);
        }
        $this->DestinationCode = $destinationCode;
        return $this;
    }
    /**
     * Get ModeOfTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModeOfTransport()
    {
        return isset($this->ModeOfTransport) ? $this->ModeOfTransport : null;
    }
    /**
     * Set ModeOfTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modeOfTransport
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummaryDetail
     */
    public function setModeOfTransport($modeOfTransport = null)
    {
        // validation for constraint: string
        if (!is_null($modeOfTransport) && !is_string($modeOfTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeOfTransport, true), gettype($modeOfTransport)), __LINE__);
        }
        if (is_null($modeOfTransport) || (is_array($modeOfTransport) && empty($modeOfTransport))) {
            unset($this->ModeOfTransport);
        } else {
            $this->ModeOfTransport = $modeOfTransport;
        }
        return $this;
    }
    /**
     * Get TotalPieces value
     * @return int|null
     */
    public function getTotalPieces()
    {
        return $this->TotalPieces;
    }
    /**
     * Set TotalPieces value
     * @param int $totalPieces
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummaryDetail
     */
    public function setTotalPieces($totalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($totalPieces) && !(is_int($totalPieces) || ctype_digit($totalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPieces, true), gettype($totalPieces)), __LINE__);
        }
        $this->TotalPieces = $totalPieces;
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return \Pepitelabs\PWS\PickUpService\Weight|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param \Pepitelabs\PWS\PickUpService\Weight $totalWeight
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummaryDetail
     */
    public function setTotalWeight(\Pepitelabs\PWS\PickUpService\Weight $totalWeight = null)
    {
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummaryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
