<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickUpDetail PickUpService
 * Meta information extracted from the WSDL
 * - documentation: PickUp Detail
 * - nillable: true
 * - type: tns:PickUpDetail
 * @subpackage Structs
 */
class PickUpDetail extends AbstractStructBase
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The PartnerId
     * Meta information extracted from the WSDL
     * - documentation: PartnerID - string
     * - nillable: true
     * @var string
     */
    public $PartnerId;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - documentation: ConfirmationNumber - string
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The PickupStatus
     * Meta information extracted from the WSDL
     * - documentation: PickupStatus - string
     * - nillable: true
     * @var string
     */
    public $PickupStatus;
    /**
     * The PickupType
     * Meta information extracted from the WSDL
     * - documentation: PickupType - string
     * - nillable: true
     * @var string
     */
    public $PickupType;
    /**
     * The PickupInstruction
     * Meta information extracted from the WSDL
     * - documentation: PickupInstruction - PickupInstruction
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public $PickupInstruction;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\Address
     */
    public $Address;
    /**
     * The ShipmentSummary
     * Meta information extracted from the WSDL
     * - documentation: ShipmentSummary - ShipmentSummary
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\ShipmentSummary
     */
    public $ShipmentSummary;
    /**
     * The NotificationEmails
     * Meta information extracted from the WSDL
     * - documentation: NotificationEmails - string[]
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\ArrayOfstring
     */
    public $NotificationEmails;
    /**
     * Constructor method for PickUpDetail
     * @uses PickUpDetail::setBillingAccountNumber()
     * @uses PickUpDetail::setPartnerId()
     * @uses PickUpDetail::setConfirmationNumber()
     * @uses PickUpDetail::setPickupStatus()
     * @uses PickUpDetail::setPickupType()
     * @uses PickUpDetail::setPickupInstruction()
     * @uses PickUpDetail::setAddress()
     * @uses PickUpDetail::setShipmentSummary()
     * @uses PickUpDetail::setNotificationEmails()
     * @param string $billingAccountNumber
     * @param string $partnerId
     * @param string $confirmationNumber
     * @param string $pickupStatus
     * @param string $pickupType
     * @param \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction
     * @param \Pepitelabs\PWS\PickUpService\Address $address
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     * @param \Pepitelabs\PWS\PickUpService\ArrayOfstring $notificationEmails
     */
    public function __construct($billingAccountNumber = null, $partnerId = null, $confirmationNumber = null, $pickupStatus = null, $pickupType = null, \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction = null, \Pepitelabs\PWS\PickUpService\Address $address = null, \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null, \Pepitelabs\PWS\PickUpService\ArrayOfstring $notificationEmails = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setPartnerId($partnerId)
            ->setConfirmationNumber($confirmationNumber)
            ->setPickupStatus($pickupStatus)
            ->setPickupType($pickupType)
            ->setPickupInstruction($pickupInstruction)
            ->setAddress($address)
            ->setShipmentSummary($shipmentSummary)
            ->setNotificationEmails($notificationEmails);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get PartnerId value
     * @return string|null
     */
    public function getPartnerId()
    {
        return $this->PartnerId;
    }
    /**
     * Set PartnerId value
     * @param string $partnerId
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setPartnerId($partnerId = null)
    {
        // validation for constraint: string
        if (!is_null($partnerId) && !is_string($partnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerId, true), gettype($partnerId)), __LINE__);
        }
        $this->PartnerId = $partnerId;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get PickupStatus value
     * @return string|null
     */
    public function getPickupStatus()
    {
        return $this->PickupStatus;
    }
    /**
     * Set PickupStatus value
     * @param string $pickupStatus
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setPickupStatus($pickupStatus = null)
    {
        // validation for constraint: string
        if (!is_null($pickupStatus) && !is_string($pickupStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupStatus, true), gettype($pickupStatus)), __LINE__);
        }
        $this->PickupStatus = $pickupStatus;
        return $this;
    }
    /**
     * Get PickupType value
     * @return string|null
     */
    public function getPickupType()
    {
        return $this->PickupType;
    }
    /**
     * Set PickupType value
     * @param string $pickupType
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setPickupType($pickupType = null)
    {
        // validation for constraint: string
        if (!is_null($pickupType) && !is_string($pickupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupType, true), gettype($pickupType)), __LINE__);
        }
        $this->PickupType = $pickupType;
        return $this;
    }
    /**
     * Get PickupInstruction value
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction|null
     */
    public function getPickupInstruction()
    {
        return $this->PickupInstruction;
    }
    /**
     * Set PickupInstruction value
     * @param \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setPickupInstruction(\Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction = null)
    {
        $this->PickupInstruction = $pickupInstruction;
        return $this;
    }
    /**
     * Get Address value
     * @return \Pepitelabs\PWS\PickUpService\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Pepitelabs\PWS\PickUpService\Address $address
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setAddress(\Pepitelabs\PWS\PickUpService\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ShipmentSummary value
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummary|null
     */
    public function getShipmentSummary()
    {
        return $this->ShipmentSummary;
    }
    /**
     * Set ShipmentSummary value
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setShipmentSummary(\Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null)
    {
        $this->ShipmentSummary = $shipmentSummary;
        return $this;
    }
    /**
     * Get NotificationEmails value
     * @return \Pepitelabs\PWS\PickUpService\ArrayOfstring|null
     */
    public function getNotificationEmails()
    {
        return $this->NotificationEmails;
    }
    /**
     * Set NotificationEmails value
     * @param \Pepitelabs\PWS\PickUpService\ArrayOfstring $notificationEmails
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public function setNotificationEmails(\Pepitelabs\PWS\PickUpService\ArrayOfstring $notificationEmails = null)
    {
        $this->NotificationEmails = $notificationEmails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\PickUpDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
