<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPickupInstruction PickUpService
 * Meta information extracted from the WSDL
 * - documentation: ModifyPickupInstruction
 * - nillable: true
 * - type: tns:ModifyPickupInstruction
 * @subpackage Structs
 */
class ModifyPickupInstruction extends AbstractStructBase
{
    /**
     * The UntilTime
     * Meta information extracted from the WSDL
     * - documentation: String - UntilTime
     * - nillable: true
     * @var string
     */
    public $UntilTime;
    /**
     * The PickUpLocation
     * Meta information extracted from the WSDL
     * - documentation: String? - PhysicalLocation
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickUpLocation;
    /**
     * The SupplyRequestCodes
     * Meta information extracted from the WSDL
     * - documentation: SupplyRequestCodes - string[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\SupplyRequestCodes
     */
    public $SupplyRequestCodes;
    /**
     * The TrailerAccessible
     * Meta information extracted from the WSDL
     * - documentation: bool - TrailerAccessible
     * - minOccurs: 0
     * @var bool
     */
    public $TrailerAccessible;
    /**
     * The LoadingDockAvailable
     * Meta information extracted from the WSDL
     * - documentation: bool - LoadingDockAvailable
     * - minOccurs: 0
     * @var bool
     */
    public $LoadingDockAvailable;
    /**
     * The ShipmentOnSkids
     * Meta information extracted from the WSDL
     * - documentation: bool - ShipmentOnSkids
     * - minOccurs: 0
     * @var bool
     */
    public $ShipmentOnSkids;
    /**
     * The NumberOfSkids
     * Meta information extracted from the WSDL
     * - documentation: int? - NumberOfSkids
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfSkids;
    /**
     * Constructor method for ModifyPickupInstruction
     * @uses ModifyPickupInstruction::setUntilTime()
     * @uses ModifyPickupInstruction::setPickUpLocation()
     * @uses ModifyPickupInstruction::setSupplyRequestCodes()
     * @uses ModifyPickupInstruction::setTrailerAccessible()
     * @uses ModifyPickupInstruction::setLoadingDockAvailable()
     * @uses ModifyPickupInstruction::setShipmentOnSkids()
     * @uses ModifyPickupInstruction::setNumberOfSkids()
     * @param string $untilTime
     * @param string $pickUpLocation
     * @param \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes
     * @param bool $trailerAccessible
     * @param bool $loadingDockAvailable
     * @param bool $shipmentOnSkids
     * @param int $numberOfSkids
     */
    public function __construct($untilTime = null, $pickUpLocation = null, \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes = null, $trailerAccessible = null, $loadingDockAvailable = null, $shipmentOnSkids = null, $numberOfSkids = null)
    {
        $this
            ->setUntilTime($untilTime)
            ->setPickUpLocation($pickUpLocation)
            ->setSupplyRequestCodes($supplyRequestCodes)
            ->setTrailerAccessible($trailerAccessible)
            ->setLoadingDockAvailable($loadingDockAvailable)
            ->setShipmentOnSkids($shipmentOnSkids)
            ->setNumberOfSkids($numberOfSkids);
    }
    /**
     * Get UntilTime value
     * @return string|null
     */
    public function getUntilTime()
    {
        return $this->UntilTime;
    }
    /**
     * Set UntilTime value
     * @param string $untilTime
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setUntilTime($untilTime = null)
    {
        // validation for constraint: string
        if (!is_null($untilTime) && !is_string($untilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilTime, true), gettype($untilTime)), __LINE__);
        }
        $this->UntilTime = $untilTime;
        return $this;
    }
    /**
     * Get PickUpLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickUpLocation()
    {
        return isset($this->PickUpLocation) ? $this->PickUpLocation : null;
    }
    /**
     * Set PickUpLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickUpLocation
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setPickUpLocation($pickUpLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpLocation) && !is_string($pickUpLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpLocation, true), gettype($pickUpLocation)), __LINE__);
        }
        if (is_null($pickUpLocation) || (is_array($pickUpLocation) && empty($pickUpLocation))) {
            unset($this->PickUpLocation);
        } else {
            $this->PickUpLocation = $pickUpLocation;
        }
        return $this;
    }
    /**
     * Get SupplyRequestCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\SupplyRequestCodes|null
     */
    public function getSupplyRequestCodes()
    {
        return isset($this->SupplyRequestCodes) ? $this->SupplyRequestCodes : null;
    }
    /**
     * Set SupplyRequestCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setSupplyRequestCodes(\Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes = null)
    {
        if (is_null($supplyRequestCodes) || (is_array($supplyRequestCodes) && empty($supplyRequestCodes))) {
            unset($this->SupplyRequestCodes);
        } else {
            $this->SupplyRequestCodes = $supplyRequestCodes;
        }
        return $this;
    }
    /**
     * Get TrailerAccessible value
     * @return bool|null
     */
    public function getTrailerAccessible()
    {
        return $this->TrailerAccessible;
    }
    /**
     * Set TrailerAccessible value
     * @param bool $trailerAccessible
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setTrailerAccessible($trailerAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($trailerAccessible) && !is_bool($trailerAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trailerAccessible, true), gettype($trailerAccessible)), __LINE__);
        }
        $this->TrailerAccessible = $trailerAccessible;
        return $this;
    }
    /**
     * Get LoadingDockAvailable value
     * @return bool|null
     */
    public function getLoadingDockAvailable()
    {
        return $this->LoadingDockAvailable;
    }
    /**
     * Set LoadingDockAvailable value
     * @param bool $loadingDockAvailable
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setLoadingDockAvailable($loadingDockAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadingDockAvailable) && !is_bool($loadingDockAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadingDockAvailable, true), gettype($loadingDockAvailable)), __LINE__);
        }
        $this->LoadingDockAvailable = $loadingDockAvailable;
        return $this;
    }
    /**
     * Get ShipmentOnSkids value
     * @return bool|null
     */
    public function getShipmentOnSkids()
    {
        return $this->ShipmentOnSkids;
    }
    /**
     * Set ShipmentOnSkids value
     * @param bool $shipmentOnSkids
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setShipmentOnSkids($shipmentOnSkids = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipmentOnSkids) && !is_bool($shipmentOnSkids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipmentOnSkids, true), gettype($shipmentOnSkids)), __LINE__);
        }
        $this->ShipmentOnSkids = $shipmentOnSkids;
        return $this;
    }
    /**
     * Get NumberOfSkids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfSkids()
    {
        return isset($this->NumberOfSkids) ? $this->NumberOfSkids : null;
    }
    /**
     * Set NumberOfSkids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfSkids
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public function setNumberOfSkids($numberOfSkids = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSkids) && !(is_int($numberOfSkids) || ctype_digit($numberOfSkids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSkids, true), gettype($numberOfSkids)), __LINE__);
        }
        if (is_null($numberOfSkids) || (is_array($numberOfSkids) && empty($numberOfSkids))) {
            unset($this->NumberOfSkids);
        } else {
            $this->NumberOfSkids = $numberOfSkids;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
