<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pepitelabs\PWS\ClassMap::get(),
);
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \Pepitelabs\PWS\PickUpService\Schedule($options);
$schedule->setSoapHeaderRequestContext(new \Pepitelabs\PWS\PickUpService\RequestContext());
/**
 * Sample call for SchedulePickUp operation/method
 */
if ($schedule->SchedulePickUp(new \Pepitelabs\PWS\PickUpService\SchedulePickUpRequestContainer()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \Pepitelabs\PWS\PickUpService\_Void($options);
$void->setSoapHeaderRequestContext(new \Pepitelabs\PWS\PickUpService\RequestContext());
/**
 * Sample call for VoidPickUp operation/method
 */
if ($void->VoidPickUp(new \Pepitelabs\PWS\PickUpService\VoidPickUpRequestContainer()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \Pepitelabs\PWS\PickUpService\Validate($options);
$validate->setSoapHeaderRequestContext(new \Pepitelabs\PWS\PickUpService\RequestContext());
/**
 * Sample call for ValidatePickUp operation/method
 */
if ($validate->ValidatePickUp(new \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Pepitelabs\PWS\PickUpService\Get($options);
$get->setSoapHeaderRequestContext(new \Pepitelabs\PWS\PickUpService\RequestContext());
/**
 * Sample call for GetPickUpHistory operation/method
 */
if ($get->GetPickUpHistory(new \Pepitelabs\PWS\PickUpService\GetPickUpHistoryRequestContainer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \Pepitelabs\PWS\PickUpService\Modify($options);
$modify->setSoapHeaderRequestContext(new \Pepitelabs\PWS\PickUpService\RequestContext());
/**
 * Sample call for ModifyPickUp operation/method
 */
if ($modify->ModifyPickUp(new \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
