<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatePickUpRequestContainer PickUpService
 * Meta information extracted from the WSDL
 * - documentation: ValidatePickUpRequestContainer
 * - nillable: true
 * - type: tns:ValidatePickUpRequestContainer
 * @subpackage Structs
 */
class ValidatePickUpRequestContainer extends RequestContainer
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: PartnerID - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerID;
    /**
     * The PickupInstruction
     * Meta information extracted from the WSDL
     * - documentation: PickupInstruction - PickupInstruction
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public $PickupInstruction;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\Address
     */
    public $Address;
    /**
     * The ShipmentSummary
     * Meta information extracted from the WSDL
     * - documentation: ShipmentSummary - ShipmentSummary
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\ShipmentSummary
     */
    public $ShipmentSummary;
    /**
     * The NotificationEmails
     * Meta information extracted from the WSDL
     * - documentation: NotificationEmails - NotificationEmail[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\NotificationEmails
     */
    public $NotificationEmails;
    /**
     * Constructor method for ValidatePickUpRequestContainer
     * @uses ValidatePickUpRequestContainer::setBillingAccountNumber()
     * @uses ValidatePickUpRequestContainer::setPartnerID()
     * @uses ValidatePickUpRequestContainer::setPickupInstruction()
     * @uses ValidatePickUpRequestContainer::setAddress()
     * @uses ValidatePickUpRequestContainer::setShipmentSummary()
     * @uses ValidatePickUpRequestContainer::setNotificationEmails()
     * @param string $billingAccountNumber
     * @param string $partnerID
     * @param \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction
     * @param \Pepitelabs\PWS\PickUpService\Address $address
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     * @param \Pepitelabs\PWS\PickUpService\NotificationEmails $notificationEmails
     */
    public function __construct($billingAccountNumber = null, $partnerID = null, \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction = null, \Pepitelabs\PWS\PickUpService\Address $address = null, \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null, \Pepitelabs\PWS\PickUpService\NotificationEmails $notificationEmails = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setPartnerID($partnerID)
            ->setPickupInstruction($pickupInstruction)
            ->setAddress($address)
            ->setShipmentSummary($shipmentSummary)
            ->setNotificationEmails($notificationEmails);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get PartnerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerID()
    {
        return isset($this->PartnerID) ? $this->PartnerID : null;
    }
    /**
     * Set PartnerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerID
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        if (is_null($partnerID) || (is_array($partnerID) && empty($partnerID))) {
            unset($this->PartnerID);
        } else {
            $this->PartnerID = $partnerID;
        }
        return $this;
    }
    /**
     * Get PickupInstruction value
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction|null
     */
    public function getPickupInstruction()
    {
        return $this->PickupInstruction;
    }
    /**
     * Set PickupInstruction value
     * @param \Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setPickupInstruction(\Pepitelabs\PWS\PickUpService\PickupInstruction $pickupInstruction = null)
    {
        $this->PickupInstruction = $pickupInstruction;
        return $this;
    }
    /**
     * Get Address value
     * @return \Pepitelabs\PWS\PickUpService\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Pepitelabs\PWS\PickUpService\Address $address
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setAddress(\Pepitelabs\PWS\PickUpService\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ShipmentSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummary|null
     */
    public function getShipmentSummary()
    {
        return isset($this->ShipmentSummary) ? $this->ShipmentSummary : null;
    }
    /**
     * Set ShipmentSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setShipmentSummary(\Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null)
    {
        if (is_null($shipmentSummary) || (is_array($shipmentSummary) && empty($shipmentSummary))) {
            unset($this->ShipmentSummary);
        } else {
            $this->ShipmentSummary = $shipmentSummary;
        }
        return $this;
    }
    /**
     * Get NotificationEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\NotificationEmails|null
     */
    public function getNotificationEmails()
    {
        return isset($this->NotificationEmails) ? $this->NotificationEmails : null;
    }
    /**
     * Set NotificationEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\NotificationEmails $notificationEmails
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public function setNotificationEmails(\Pepitelabs\PWS\PickUpService\NotificationEmails $notificationEmails = null)
    {
        if (is_null($notificationEmails) || (is_array($notificationEmails) && empty($notificationEmails))) {
            unset($this->NotificationEmails);
        } else {
            $this->NotificationEmails = $notificationEmails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\ValidatePickUpRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
