<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplyRequestCodes PickUpService
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SupplyRequestCodes
 * @subpackage Structs
 */
class SupplyRequestCodes extends AbstractStructBase
{
    /**
     * The SupplyRequestCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SupplyRequestCode;
    /**
     * Constructor method for SupplyRequestCodes
     * @uses SupplyRequestCodes::setSupplyRequestCode()
     * @param string[] $supplyRequestCode
     */
    public function __construct(array $supplyRequestCode = array())
    {
        $this
            ->setSupplyRequestCode($supplyRequestCode);
    }
    /**
     * Get SupplyRequestCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSupplyRequestCode()
    {
        return isset($this->SupplyRequestCode) ? $this->SupplyRequestCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplyRequestCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplyRequestCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplyRequestCodeForArrayConstraintsFromSetSupplyRequestCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplyRequestCodesSupplyRequestCodeItem) {
            // validation for constraint: itemType
            if (!is_string($supplyRequestCodesSupplyRequestCodeItem)) {
                $invalidValues[] = is_object($supplyRequestCodesSupplyRequestCodeItem) ? get_class($supplyRequestCodesSupplyRequestCodeItem) : sprintf('%s(%s)', gettype($supplyRequestCodesSupplyRequestCodeItem), var_export($supplyRequestCodesSupplyRequestCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplyRequestCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplyRequestCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $supplyRequestCode
     * @return \Pepitelabs\PWS\PickUpService\SupplyRequestCodes
     */
    public function setSupplyRequestCode(array $supplyRequestCode = array())
    {
        // validation for constraint: array
        if ('' !== ($supplyRequestCodeArrayErrorMessage = self::validateSupplyRequestCodeForArrayConstraintsFromSetSupplyRequestCode($supplyRequestCode))) {
            throw new \InvalidArgumentException($supplyRequestCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($supplyRequestCode) || (is_array($supplyRequestCode) && empty($supplyRequestCode))) {
            unset($this->SupplyRequestCode);
        } else {
            $this->SupplyRequestCode = $supplyRequestCode;
        }
        return $this;
    }
    /**
     * Add item to SupplyRequestCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pepitelabs\PWS\PickUpService\SupplyRequestCodes
     */
    public function addToSupplyRequestCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SupplyRequestCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplyRequestCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\SupplyRequestCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
