<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupInstruction PickUpService
 * Meta information extracted from the WSDL
 * - documentation: PickupInstruction
 * - nillable: true
 * - type: tns:PickupInstruction
 * @subpackage Structs
 */
class PickupInstruction extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: String - Date
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The AnyTimeAfter
     * Meta information extracted from the WSDL
     * - documentation: String - AnyTimeAfter
     * - nillable: true
     * @var string
     */
    public $AnyTimeAfter;
    /**
     * The UntilTime
     * Meta information extracted from the WSDL
     * - documentation: String - UntilTime
     * - nillable: true
     * @var string
     */
    public $UntilTime;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - documentation: Weight - TotalWeight
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\Weight
     */
    public $TotalWeight;
    /**
     * The TotalPieces
     * Meta information extracted from the WSDL
     * - documentation: int - TotalPieces
     * - minOccurs: 0
     * @var int
     */
    public $TotalPieces;
    /**
     * The BoxesIndicator
     * Meta information extracted from the WSDL
     * - documentation: String? - BoxesIndicator
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BoxesIndicator;
    /**
     * The PickUpLocation
     * Meta information extracted from the WSDL
     * - documentation: String? - PhysicalLocation
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickUpLocation;
    /**
     * The AdditionalInstructions
     * Meta information extracted from the WSDL
     * - documentation: String? - AdditionalInstructions
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalInstructions;
    /**
     * The SupplyRequestCodes
     * Meta information extracted from the WSDL
     * - documentation: SupplyRequestCodes - string[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\SupplyRequestCodes
     */
    public $SupplyRequestCodes;
    /**
     * The TrailerAccessible
     * Meta information extracted from the WSDL
     * - documentation: bool - TrailerAccessible
     * - minOccurs: 0
     * @var bool
     */
    public $TrailerAccessible;
    /**
     * The LoadingDockAvailable
     * Meta information extracted from the WSDL
     * - documentation: bool - LoadingDockAvailable
     * - minOccurs: 0
     * @var bool
     */
    public $LoadingDockAvailable;
    /**
     * The ShipmentOnSkids
     * Meta information extracted from the WSDL
     * - documentation: bool - ShipmentOnSkids
     * - minOccurs: 0
     * @var bool
     */
    public $ShipmentOnSkids;
    /**
     * The NumberOfSkids
     * Meta information extracted from the WSDL
     * - documentation: int? - NumberOfSkids
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfSkids;
    /**
     * Constructor method for PickupInstruction
     * @uses PickupInstruction::setDate()
     * @uses PickupInstruction::setAnyTimeAfter()
     * @uses PickupInstruction::setUntilTime()
     * @uses PickupInstruction::setTotalWeight()
     * @uses PickupInstruction::setTotalPieces()
     * @uses PickupInstruction::setBoxesIndicator()
     * @uses PickupInstruction::setPickUpLocation()
     * @uses PickupInstruction::setAdditionalInstructions()
     * @uses PickupInstruction::setSupplyRequestCodes()
     * @uses PickupInstruction::setTrailerAccessible()
     * @uses PickupInstruction::setLoadingDockAvailable()
     * @uses PickupInstruction::setShipmentOnSkids()
     * @uses PickupInstruction::setNumberOfSkids()
     * @param string $date
     * @param string $anyTimeAfter
     * @param string $untilTime
     * @param \Pepitelabs\PWS\PickUpService\Weight $totalWeight
     * @param int $totalPieces
     * @param string $boxesIndicator
     * @param string $pickUpLocation
     * @param string $additionalInstructions
     * @param \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes
     * @param bool $trailerAccessible
     * @param bool $loadingDockAvailable
     * @param bool $shipmentOnSkids
     * @param int $numberOfSkids
     */
    public function __construct($date = null, $anyTimeAfter = null, $untilTime = null, \Pepitelabs\PWS\PickUpService\Weight $totalWeight = null, $totalPieces = null, $boxesIndicator = null, $pickUpLocation = null, $additionalInstructions = null, \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes = null, $trailerAccessible = null, $loadingDockAvailable = null, $shipmentOnSkids = null, $numberOfSkids = null)
    {
        $this
            ->setDate($date)
            ->setAnyTimeAfter($anyTimeAfter)
            ->setUntilTime($untilTime)
            ->setTotalWeight($totalWeight)
            ->setTotalPieces($totalPieces)
            ->setBoxesIndicator($boxesIndicator)
            ->setPickUpLocation($pickUpLocation)
            ->setAdditionalInstructions($additionalInstructions)
            ->setSupplyRequestCodes($supplyRequestCodes)
            ->setTrailerAccessible($trailerAccessible)
            ->setLoadingDockAvailable($loadingDockAvailable)
            ->setShipmentOnSkids($shipmentOnSkids)
            ->setNumberOfSkids($numberOfSkids);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AnyTimeAfter value
     * @return string|null
     */
    public function getAnyTimeAfter()
    {
        return $this->AnyTimeAfter;
    }
    /**
     * Set AnyTimeAfter value
     * @param string $anyTimeAfter
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setAnyTimeAfter($anyTimeAfter = null)
    {
        // validation for constraint: string
        if (!is_null($anyTimeAfter) && !is_string($anyTimeAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anyTimeAfter, true), gettype($anyTimeAfter)), __LINE__);
        }
        $this->AnyTimeAfter = $anyTimeAfter;
        return $this;
    }
    /**
     * Get UntilTime value
     * @return string|null
     */
    public function getUntilTime()
    {
        return $this->UntilTime;
    }
    /**
     * Set UntilTime value
     * @param string $untilTime
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setUntilTime($untilTime = null)
    {
        // validation for constraint: string
        if (!is_null($untilTime) && !is_string($untilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilTime, true), gettype($untilTime)), __LINE__);
        }
        $this->UntilTime = $untilTime;
        return $this;
    }
    /**
     * Get TotalWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\Weight|null
     */
    public function getTotalWeight()
    {
        return isset($this->TotalWeight) ? $this->TotalWeight : null;
    }
    /**
     * Set TotalWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\Weight $totalWeight
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setTotalWeight(\Pepitelabs\PWS\PickUpService\Weight $totalWeight = null)
    {
        if (is_null($totalWeight) || (is_array($totalWeight) && empty($totalWeight))) {
            unset($this->TotalWeight);
        } else {
            $this->TotalWeight = $totalWeight;
        }
        return $this;
    }
    /**
     * Get TotalPieces value
     * @return int|null
     */
    public function getTotalPieces()
    {
        return $this->TotalPieces;
    }
    /**
     * Set TotalPieces value
     * @param int $totalPieces
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setTotalPieces($totalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($totalPieces) && !(is_int($totalPieces) || ctype_digit($totalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPieces, true), gettype($totalPieces)), __LINE__);
        }
        $this->TotalPieces = $totalPieces;
        return $this;
    }
    /**
     * Get BoxesIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBoxesIndicator()
    {
        return isset($this->BoxesIndicator) ? $this->BoxesIndicator : null;
    }
    /**
     * Set BoxesIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $boxesIndicator
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setBoxesIndicator($boxesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($boxesIndicator) && !is_string($boxesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxesIndicator, true), gettype($boxesIndicator)), __LINE__);
        }
        if (is_null($boxesIndicator) || (is_array($boxesIndicator) && empty($boxesIndicator))) {
            unset($this->BoxesIndicator);
        } else {
            $this->BoxesIndicator = $boxesIndicator;
        }
        return $this;
    }
    /**
     * Get PickUpLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickUpLocation()
    {
        return isset($this->PickUpLocation) ? $this->PickUpLocation : null;
    }
    /**
     * Set PickUpLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickUpLocation
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setPickUpLocation($pickUpLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpLocation) && !is_string($pickUpLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpLocation, true), gettype($pickUpLocation)), __LINE__);
        }
        if (is_null($pickUpLocation) || (is_array($pickUpLocation) && empty($pickUpLocation))) {
            unset($this->PickUpLocation);
        } else {
            $this->PickUpLocation = $pickUpLocation;
        }
        return $this;
    }
    /**
     * Get AdditionalInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalInstructions()
    {
        return isset($this->AdditionalInstructions) ? $this->AdditionalInstructions : null;
    }
    /**
     * Set AdditionalInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalInstructions
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setAdditionalInstructions($additionalInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInstructions) && !is_string($additionalInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInstructions, true), gettype($additionalInstructions)), __LINE__);
        }
        if (is_null($additionalInstructions) || (is_array($additionalInstructions) && empty($additionalInstructions))) {
            unset($this->AdditionalInstructions);
        } else {
            $this->AdditionalInstructions = $additionalInstructions;
        }
        return $this;
    }
    /**
     * Get SupplyRequestCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\SupplyRequestCodes|null
     */
    public function getSupplyRequestCodes()
    {
        return isset($this->SupplyRequestCodes) ? $this->SupplyRequestCodes : null;
    }
    /**
     * Set SupplyRequestCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setSupplyRequestCodes(\Pepitelabs\PWS\PickUpService\SupplyRequestCodes $supplyRequestCodes = null)
    {
        if (is_null($supplyRequestCodes) || (is_array($supplyRequestCodes) && empty($supplyRequestCodes))) {
            unset($this->SupplyRequestCodes);
        } else {
            $this->SupplyRequestCodes = $supplyRequestCodes;
        }
        return $this;
    }
    /**
     * Get TrailerAccessible value
     * @return bool|null
     */
    public function getTrailerAccessible()
    {
        return $this->TrailerAccessible;
    }
    /**
     * Set TrailerAccessible value
     * @param bool $trailerAccessible
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setTrailerAccessible($trailerAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($trailerAccessible) && !is_bool($trailerAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trailerAccessible, true), gettype($trailerAccessible)), __LINE__);
        }
        $this->TrailerAccessible = $trailerAccessible;
        return $this;
    }
    /**
     * Get LoadingDockAvailable value
     * @return bool|null
     */
    public function getLoadingDockAvailable()
    {
        return $this->LoadingDockAvailable;
    }
    /**
     * Set LoadingDockAvailable value
     * @param bool $loadingDockAvailable
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setLoadingDockAvailable($loadingDockAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadingDockAvailable) && !is_bool($loadingDockAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadingDockAvailable, true), gettype($loadingDockAvailable)), __LINE__);
        }
        $this->LoadingDockAvailable = $loadingDockAvailable;
        return $this;
    }
    /**
     * Get ShipmentOnSkids value
     * @return bool|null
     */
    public function getShipmentOnSkids()
    {
        return $this->ShipmentOnSkids;
    }
    /**
     * Set ShipmentOnSkids value
     * @param bool $shipmentOnSkids
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setShipmentOnSkids($shipmentOnSkids = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipmentOnSkids) && !is_bool($shipmentOnSkids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipmentOnSkids, true), gettype($shipmentOnSkids)), __LINE__);
        }
        $this->ShipmentOnSkids = $shipmentOnSkids;
        return $this;
    }
    /**
     * Get NumberOfSkids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfSkids()
    {
        return isset($this->NumberOfSkids) ? $this->NumberOfSkids : null;
    }
    /**
     * Set NumberOfSkids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfSkids
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public function setNumberOfSkids($numberOfSkids = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSkids) && !(is_int($numberOfSkids) || ctype_digit($numberOfSkids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSkids, true), gettype($numberOfSkids)), __LINE__);
        }
        if (is_null($numberOfSkids) || (is_array($numberOfSkids) && empty($numberOfSkids))) {
            unset($this->NumberOfSkids);
        } else {
            $this->NumberOfSkids = $numberOfSkids;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\PickupInstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
