<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickUpHistorySearchCriteria PickUpService
 * Meta information extracted from the WSDL
 * - documentation: PickUpHistorySearchCriteria
 * - nillable: true
 * - type: tns:PickUpHistorySearchCriteria
 * @subpackage Structs
 */
class PickUpHistorySearchCriteria extends AbstractStructBase
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - documentation: FromDate
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - documentation: ToDate
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - documentation: ConfirmationNumber
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: AccountNumber
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The MaxNumOfRecords
     * Meta information extracted from the WSDL
     * - documentation: MaxNumOfRecords
     * - minOccurs: 0
     * @var int
     */
    public $MaxNumOfRecords;
    /**
     * The SortColumn
     * Meta information extracted from the WSDL
     * - documentation: SortColumn
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SortColumn;
    /**
     * The SortDirection
     * Meta information extracted from the WSDL
     * - documentation: SortDirection
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SortDirection;
    /**
     * Constructor method for PickUpHistorySearchCriteria
     * @uses PickUpHistorySearchCriteria::setFromDate()
     * @uses PickUpHistorySearchCriteria::setToDate()
     * @uses PickUpHistorySearchCriteria::setConfirmationNumber()
     * @uses PickUpHistorySearchCriteria::setAccountNumber()
     * @uses PickUpHistorySearchCriteria::setStatus()
     * @uses PickUpHistorySearchCriteria::setMaxNumOfRecords()
     * @uses PickUpHistorySearchCriteria::setSortColumn()
     * @uses PickUpHistorySearchCriteria::setSortDirection()
     * @param string $fromDate
     * @param string $toDate
     * @param string $confirmationNumber
     * @param string $accountNumber
     * @param string $status
     * @param int $maxNumOfRecords
     * @param string $sortColumn
     * @param string $sortDirection
     */
    public function __construct($fromDate = null, $toDate = null, $confirmationNumber = null, $accountNumber = null, $status = null, $maxNumOfRecords = null, $sortColumn = null, $sortDirection = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setConfirmationNumber($confirmationNumber)
            ->setAccountNumber($accountNumber)
            ->setStatus($status)
            ->setMaxNumOfRecords($maxNumOfRecords)
            ->setSortColumn($sortColumn)
            ->setSortDirection($sortDirection);
    }
    /**
     * Get FromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get MaxNumOfRecords value
     * @return int|null
     */
    public function getMaxNumOfRecords()
    {
        return $this->MaxNumOfRecords;
    }
    /**
     * Set MaxNumOfRecords value
     * @param int $maxNumOfRecords
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setMaxNumOfRecords($maxNumOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumOfRecords) && !(is_int($maxNumOfRecords) || ctype_digit($maxNumOfRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumOfRecords, true), gettype($maxNumOfRecords)), __LINE__);
        }
        $this->MaxNumOfRecords = $maxNumOfRecords;
        return $this;
    }
    /**
     * Get SortColumn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSortColumn()
    {
        return isset($this->SortColumn) ? $this->SortColumn : null;
    }
    /**
     * Set SortColumn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sortColumn
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumn) && !is_string($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortColumn, true), gettype($sortColumn)), __LINE__);
        }
        if (is_null($sortColumn) || (is_array($sortColumn) && empty($sortColumn))) {
            unset($this->SortColumn);
        } else {
            $this->SortColumn = $sortColumn;
        }
        return $this;
    }
    /**
     * Get SortDirection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSortDirection()
    {
        return isset($this->SortDirection) ? $this->SortDirection : null;
    }
    /**
     * Set SortDirection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sortDirection
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public function setSortDirection($sortDirection = null)
    {
        // validation for constraint: string
        if (!is_null($sortDirection) && !is_string($sortDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortDirection, true), gettype($sortDirection)), __LINE__);
        }
        if (is_null($sortDirection) || (is_array($sortDirection) && empty($sortDirection))) {
            unset($this->SortDirection);
        } else {
            $this->SortDirection = $sortDirection;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\PickUpHistorySearchCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
