<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPickUpRequestContainer PickUpService
 * Meta information extracted from the WSDL
 * - documentation: ModifyPickUpRequestContainer
 * - nillable: true
 * - type: tns:ModifyPickUpRequestContainer
 * @subpackage Structs
 */
class ModifyPickUpRequestContainer extends RequestContainer
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - documentation: ConfirmationNumber - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The ModifyPickupInstruction
     * Meta information extracted from the WSDL
     * - documentation: ModifyPickupInstruction - ModifyPickupInstruction
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction
     */
    public $ModifyPickupInstruction;
    /**
     * The ShipmentSummary
     * Meta information extracted from the WSDL
     * - documentation: ShipmentSummary - ShipmentSummary
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\PickUpService\ShipmentSummary
     */
    public $ShipmentSummary;
    /**
     * Constructor method for ModifyPickUpRequestContainer
     * @uses ModifyPickUpRequestContainer::setBillingAccountNumber()
     * @uses ModifyPickUpRequestContainer::setConfirmationNumber()
     * @uses ModifyPickUpRequestContainer::setModifyPickupInstruction()
     * @uses ModifyPickUpRequestContainer::setShipmentSummary()
     * @param string $billingAccountNumber
     * @param string $confirmationNumber
     * @param \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction $modifyPickupInstruction
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     */
    public function __construct($billingAccountNumber = null, $confirmationNumber = null, \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction $modifyPickupInstruction = null, \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setModifyPickupInstruction($modifyPickupInstruction)
            ->setShipmentSummary($shipmentSummary);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get ModifyPickupInstruction value
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction|null
     */
    public function getModifyPickupInstruction()
    {
        return $this->ModifyPickupInstruction;
    }
    /**
     * Set ModifyPickupInstruction value
     * @param \Pepitelabs\PWS\PickUpService\ModifyPickupInstruction $modifyPickupInstruction
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer
     */
    public function setModifyPickupInstruction(\Pepitelabs\PWS\PickUpService\ModifyPickupInstruction $modifyPickupInstruction = null)
    {
        $this->ModifyPickupInstruction = $modifyPickupInstruction;
        return $this;
    }
    /**
     * Get ShipmentSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\PickUpService\ShipmentSummary|null
     */
    public function getShipmentSummary()
    {
        return isset($this->ShipmentSummary) ? $this->ShipmentSummary : null;
    }
    /**
     * Set ShipmentSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer
     */
    public function setShipmentSummary(\Pepitelabs\PWS\PickUpService\ShipmentSummary $shipmentSummary = null)
    {
        if (is_null($shipmentSummary) || (is_array($shipmentSummary) && empty($shipmentSummary))) {
            unset($this->ShipmentSummary);
        } else {
            $this->ShipmentSummary = $shipmentSummary;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\PickUpService\ModifyPickUpRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
