<?php

namespace Pepitelabs\PWS\PickUpService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get PickUpService
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\PickUpService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\PickUpService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetPickUpHistory
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\PickUpService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetPickUpHistory @param request GetPickUpHistoryRequest @return GetPickUpHistoryResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\PickUpService\GetPickUpHistoryRequestContainer $getPickUpHistoryRequest
     * @return \Pepitelabs\PWS\PickUpService\GetPickUpHistoryResponseContainer|bool
     */
    public function GetPickUpHistory(\Pepitelabs\PWS\PickUpService\GetPickUpHistoryRequestContainer $getPickUpHistoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPickUpHistory($getPickUpHistoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\PickUpService\GetPickUpHistoryResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
