<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentsRequestContainer ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - documentation: GetDocumentsRequest
 * - nillable: true
 * - type: tns:GetDocumentsRequestContainer
 * @subpackage Structs
 */
class GetDocumentsRequestContainer extends RequestContainer
{
    /**
     * The OutputType
     * Meta information extracted from the WSDL
     * - documentation: OutputType - string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OutputType;
    /**
     * The Synchronous
     * Meta information extracted from the WSDL
     * - documentation: Synchronous - boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Synchronous;
    /**
     * The DocumentCriterium
     * Meta information extracted from the WSDL
     * - documentation: DocumentCriterium - DocumentCriteria[]
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria
     */
    public $DocumentCriterium;
    /**
     * Constructor method for GetDocumentsRequestContainer
     * @uses GetDocumentsRequestContainer::setOutputType()
     * @uses GetDocumentsRequestContainer::setSynchronous()
     * @uses GetDocumentsRequestContainer::setDocumentCriterium()
     * @param string $outputType
     * @param bool $synchronous
     * @param \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria $documentCriterium
     */
    public function __construct($outputType = null, $synchronous = null, \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria $documentCriterium = null)
    {
        $this
            ->setOutputType($outputType)
            ->setSynchronous($synchronous)
            ->setDocumentCriterium($documentCriterium);
    }
    /**
     * Get OutputType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutputType()
    {
        return isset($this->OutputType) ? $this->OutputType : null;
    }
    /**
     * Set OutputType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outputType
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer
     */
    public function setOutputType($outputType = null)
    {
        // validation for constraint: string
        if (!is_null($outputType) && !is_string($outputType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputType, true), gettype($outputType)), __LINE__);
        }
        if (is_null($outputType) || (is_array($outputType) && empty($outputType))) {
            unset($this->OutputType);
        } else {
            $this->OutputType = $outputType;
        }
        return $this;
    }
    /**
     * Get Synchronous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSynchronous()
    {
        return isset($this->Synchronous) ? $this->Synchronous : null;
    }
    /**
     * Set Synchronous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $synchronous
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer
     */
    public function setSynchronous($synchronous = null)
    {
        // validation for constraint: boolean
        if (!is_null($synchronous) && !is_bool($synchronous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($synchronous, true), gettype($synchronous)), __LINE__);
        }
        if (is_null($synchronous) || (is_array($synchronous) && empty($synchronous))) {
            unset($this->Synchronous);
        } else {
            $this->Synchronous = $synchronous;
        }
        return $this;
    }
    /**
     * Get DocumentCriterium value
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria|null
     */
    public function getDocumentCriterium()
    {
        return $this->DocumentCriterium;
    }
    /**
     * Set DocumentCriterium value
     * @param \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria $documentCriterium
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer
     */
    public function setDocumentCriterium(\Pepitelabs\PWS\ShippingDocumentsService\ArrayOfDocumentCriteria $documentCriterium = null)
    {
        $this->DocumentCriterium = $documentCriterium;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
