<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentTypes ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentTypes
 * @subpackage Structs
 */
class DocumentTypes extends AbstractStructBase
{
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DocumentType;
    /**
     * Constructor method for DocumentTypes
     * @uses DocumentTypes::setDocumentType()
     * @param string[] $documentType
     */
    public function __construct(array $documentType = array())
    {
        $this
            ->setDocumentType($documentType);
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentTypeForArrayConstraintsFromSetDocumentType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypesDocumentTypeItem) {
            // validation for constraint: itemType
            if (!is_string($documentTypesDocumentTypeItem)) {
                $invalidValues[] = is_object($documentTypesDocumentTypeItem) ? get_class($documentTypesDocumentTypeItem) : sprintf('%s(%s)', gettype($documentTypesDocumentTypeItem), var_export($documentTypesDocumentTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $documentType
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes
     */
    public function setDocumentType(array $documentType = array())
    {
        // validation for constraint: array
        if ('' !== ($documentTypeArrayErrorMessage = self::validateDocumentTypeForArrayConstraintsFromSetDocumentType($documentType))) {
            throw new \InvalidArgumentException($documentTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Add item to DocumentType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes
     */
    public function addToDocumentType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocumentType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
