<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentCriteria ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - documentation: DocumentCriteria
 * - nillable: true
 * - type: tns:DocumentCriteria
 * @subpackage Structs
 */
class DocumentCriteria extends AbstractStructBase
{
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: PIN - PIN
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingDocumentsService\PIN
     */
    public $PIN;
    /**
     * The DocumentTypes
     * Meta information extracted from the WSDL
     * - documentation: DocumentTypes - string[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes
     */
    public $DocumentTypes;
    /**
     * Constructor method for DocumentCriteria
     * @uses DocumentCriteria::setPIN()
     * @uses DocumentCriteria::setDocumentTypes()
     * @param \Pepitelabs\PWS\ShippingDocumentsService\PIN $pIN
     * @param \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes $documentTypes
     */
    public function __construct(\Pepitelabs\PWS\ShippingDocumentsService\PIN $pIN = null, \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes $documentTypes = null)
    {
        $this
            ->setPIN($pIN)
            ->setDocumentTypes($documentTypes);
    }
    /**
     * Get PIN value
     * @return \Pepitelabs\PWS\ShippingDocumentsService\PIN|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param \Pepitelabs\PWS\ShippingDocumentsService\PIN $pIN
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentCriteria
     */
    public function setPIN(\Pepitelabs\PWS\ShippingDocumentsService\PIN $pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get DocumentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes|null
     */
    public function getDocumentTypes()
    {
        return isset($this->DocumentTypes) ? $this->DocumentTypes : null;
    }
    /**
     * Set DocumentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes $documentTypes
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentCriteria
     */
    public function setDocumentTypes(\Pepitelabs\PWS\ShippingDocumentsService\DocumentTypes $documentTypes = null)
    {
        if (is_null($documentTypes) || (is_array($documentTypes) && empty($documentTypes))) {
            unset($this->DocumentTypes);
        } else {
            $this->DocumentTypes = $documentTypes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
