<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestBatch ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - documentation: Document
 * - nillable: true
 * - type: tns:ManifestBatch
 * @subpackage Structs
 */
class ManifestBatch extends AbstractStructBase
{
    /**
     * The ShipmentManifestDate
     * Meta information extracted from the WSDL
     * - documentation: string - ShipmentManifestDate
     * - nillable: true
     * @var string
     */
    public $ShipmentManifestDate;
    /**
     * The ManifestCloseDateTime
     * Meta information extracted from the WSDL
     * - documentation: string - ManifestCloseDateTime
     * - nillable: true
     * @var string
     */
    public $ManifestCloseDateTime;
    /**
     * The ManifestBatchDetails
     * Meta information extracted from the WSDL
     * - documentation: ManifestBatchDetails - ManifestBatchDetail[]
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail
     */
    public $ManifestBatchDetails;
    /**
     * Constructor method for ManifestBatch
     * @uses ManifestBatch::setShipmentManifestDate()
     * @uses ManifestBatch::setManifestCloseDateTime()
     * @uses ManifestBatch::setManifestBatchDetails()
     * @param string $shipmentManifestDate
     * @param string $manifestCloseDateTime
     * @param \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail $manifestBatchDetails
     */
    public function __construct($shipmentManifestDate = null, $manifestCloseDateTime = null, \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail $manifestBatchDetails = null)
    {
        $this
            ->setShipmentManifestDate($shipmentManifestDate)
            ->setManifestCloseDateTime($manifestCloseDateTime)
            ->setManifestBatchDetails($manifestBatchDetails);
    }
    /**
     * Get ShipmentManifestDate value
     * @return string|null
     */
    public function getShipmentManifestDate()
    {
        return $this->ShipmentManifestDate;
    }
    /**
     * Set ShipmentManifestDate value
     * @param string $shipmentManifestDate
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ManifestBatch
     */
    public function setShipmentManifestDate($shipmentManifestDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentManifestDate) && !is_string($shipmentManifestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentManifestDate, true), gettype($shipmentManifestDate)), __LINE__);
        }
        $this->ShipmentManifestDate = $shipmentManifestDate;
        return $this;
    }
    /**
     * Get ManifestCloseDateTime value
     * @return string|null
     */
    public function getManifestCloseDateTime()
    {
        return $this->ManifestCloseDateTime;
    }
    /**
     * Set ManifestCloseDateTime value
     * @param string $manifestCloseDateTime
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ManifestBatch
     */
    public function setManifestCloseDateTime($manifestCloseDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($manifestCloseDateTime) && !is_string($manifestCloseDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestCloseDateTime, true), gettype($manifestCloseDateTime)), __LINE__);
        }
        $this->ManifestCloseDateTime = $manifestCloseDateTime;
        return $this;
    }
    /**
     * Get ManifestBatchDetails value
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail|null
     */
    public function getManifestBatchDetails()
    {
        return $this->ManifestBatchDetails;
    }
    /**
     * Set ManifestBatchDetails value
     * @param \Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail $manifestBatchDetails
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ManifestBatch
     */
    public function setManifestBatchDetails(\Pepitelabs\PWS\ShippingDocumentsService\ArrayOfManifestBatchDetail $manifestBatchDetails = null)
    {
        $this->ManifestBatchDetails = $manifestBatchDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingDocumentsService\ManifestBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
