<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ShippingDocumentsService
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\ShippingDocumentsService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\ShippingDocumentsService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetDocuments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ShippingDocumentsService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetDocuments @param request GetDocumentsRequest @return GetDocumentsResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer $getDocumentsRequest
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsResponseContainer|bool
     */
    public function GetDocuments(\Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsRequestContainer $getDocumentsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocuments($getDocumentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShipmentManifestDocument
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ShippingDocumentsService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetShipmentManifestDocument @param request GetShipmentManifestRequest @return GetShipmentManifestDocumentResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ShippingDocumentsService\GetShipmentManifestDocumentRequestContainer $getShipmentManifestDocumentRequest
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetShipmentManifestDocumentResponseContainer|bool
     */
    public function GetShipmentManifestDocument(\Pepitelabs\PWS\ShippingDocumentsService\GetShipmentManifestDocumentRequestContainer $getShipmentManifestDocumentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShipmentManifestDocument($getShipmentManifestDocumentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\ShippingDocumentsService\GetDocumentsResponseContainer|\Pepitelabs\PWS\ShippingDocumentsService\GetShipmentManifestDocumentResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
