<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

/**
 * This class stands for DocumentStatus ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - documentation: DocumentStatus - enum
 * - nillable: true
 * - type: tns:DocumentStatus
 * @subpackage Enumerations
 */
class DocumentStatus
{
    /**
     * Constant for value 'Pending'
     * Meta information extracted from the WSDL
     * - documentation: Pending
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Queued'
     * Meta information extracted from the WSDL
     * - documentation: Queued
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Processing'
     * Meta information extracted from the WSDL
     * - documentation: Processing
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'Completed'
     * Meta information extracted from the WSDL
     * - documentation: Completed
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Error'
     * Meta information extracted from the WSDL
     * - documentation: Error
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_QUEUED,
            self::VALUE_PROCESSING,
            self::VALUE_COMPLETED,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
