<?php

namespace Pepitelabs\PWS\ShippingDocumentsService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDetail ShippingDocumentsService
 * Meta information extracted from the WSDL
 * - documentation: DocumentDetail
 * - nillable: true
 * - type: tns:DocumentDetail
 * @subpackage Structs
 */
class DocumentDetail extends AbstractStructBase
{
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - documentation: DocumentType - DocumentType
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DocumentStatus
     * Meta information extracted from the WSDL
     * - documentation: DocumentType - DocumentStatus
     * @var string
     */
    public $DocumentStatus;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL - string
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - documentation: Data - string
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * Constructor method for DocumentDetail
     * @uses DocumentDetail::setDocumentType()
     * @uses DocumentDetail::setDescription()
     * @uses DocumentDetail::setDocumentStatus()
     * @uses DocumentDetail::setURL()
     * @uses DocumentDetail::setData()
     * @param string $documentType
     * @param string $description
     * @param string $documentStatus
     * @param string $uRL
     * @param string $data
     */
    public function __construct($documentType = null, $description = null, $documentStatus = null, $uRL = null, $data = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDescription($description)
            ->setDocumentStatus($documentStatus)
            ->setURL($uRL)
            ->setData($data);
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocumentStatus value
     * @return string|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @uses \Pepitelabs\PWS\ShippingDocumentsService\DocumentStatus::valueIsValid()
     * @uses \Pepitelabs\PWS\ShippingDocumentsService\DocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentStatus
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ShippingDocumentsService\DocumentStatus::valueIsValid($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ShippingDocumentsService\DocumentStatus', is_array($documentStatus) ? implode(', ', $documentStatus) : var_export($documentStatus, true), implode(', ', \Pepitelabs\PWS\ShippingDocumentsService\DocumentStatus::getValidValues())), __LINE__);
        }
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingDocumentsService\DocumentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
