<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoidShipmentResponseContainer ShippingService
 * Meta information extracted from the WSDL
 * - documentation: VoidShipmentResponse
 * - nillable: true
 * - type: tns:VoidShipmentResponseContainer
 * @subpackage Structs
 */
class VoidShipmentResponseContainer extends ResponseContainer
{
    /**
     * The ShipmentVoided
     * Meta information extracted from the WSDL
     * - documentation: ShipmentVoided - bool
     * - minOccurs: 0
     * @var bool
     */
    public $ShipmentVoided;
    /**
     * Constructor method for VoidShipmentResponseContainer
     * @uses VoidShipmentResponseContainer::setShipmentVoided()
     * @param bool $shipmentVoided
     */
    public function __construct($shipmentVoided = null)
    {
        $this
            ->setShipmentVoided($shipmentVoided);
    }
    /**
     * Get ShipmentVoided value
     * @return bool|null
     */
    public function getShipmentVoided()
    {
        return $this->ShipmentVoided;
    }
    /**
     * Set ShipmentVoided value
     * @param bool $shipmentVoided
     * @return \Pepitelabs\PWS\ShippingService\VoidShipmentResponseContainer
     */
    public function setShipmentVoided($shipmentVoided = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipmentVoided) && !is_bool($shipmentVoided)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipmentVoided, true), gettype($shipmentVoided)), __LINE__);
        }
        $this->ShipmentVoided = $shipmentVoided;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\VoidShipmentResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
