<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription ShippingService
 * Meta information extracted from the WSDL
 * - documentation: Proactive Notification
 * - nillable: true
 * - type: tns:Subscription
 * @subpackage Structs
 */
class Subscription extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name -ProactiveNotification []
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Email -ProactiveNotification []
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The NotifyWhenExceptionOccurs
     * @var bool
     */
    public $NotifyWhenExceptionOccurs;
    /**
     * The NotifyWhenDeliveryOccurs
     * @var bool
     */
    public $NotifyWhenDeliveryOccurs;
    /**
     * Constructor method for Subscription
     * @uses Subscription::setName()
     * @uses Subscription::setEmail()
     * @uses Subscription::setNotifyWhenExceptionOccurs()
     * @uses Subscription::setNotifyWhenDeliveryOccurs()
     * @param string $name
     * @param string $email
     * @param bool $notifyWhenExceptionOccurs
     * @param bool $notifyWhenDeliveryOccurs
     */
    public function __construct($name = null, $email = null, $notifyWhenExceptionOccurs = null, $notifyWhenDeliveryOccurs = null)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setNotifyWhenExceptionOccurs($notifyWhenExceptionOccurs)
            ->setNotifyWhenDeliveryOccurs($notifyWhenDeliveryOccurs);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Pepitelabs\PWS\ShippingService\Subscription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Pepitelabs\PWS\ShippingService\Subscription
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get NotifyWhenExceptionOccurs value
     * @return bool|null
     */
    public function getNotifyWhenExceptionOccurs()
    {
        return $this->NotifyWhenExceptionOccurs;
    }
    /**
     * Set NotifyWhenExceptionOccurs value
     * @param bool $notifyWhenExceptionOccurs
     * @return \Pepitelabs\PWS\ShippingService\Subscription
     */
    public function setNotifyWhenExceptionOccurs($notifyWhenExceptionOccurs = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyWhenExceptionOccurs) && !is_bool($notifyWhenExceptionOccurs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notifyWhenExceptionOccurs, true), gettype($notifyWhenExceptionOccurs)), __LINE__);
        }
        $this->NotifyWhenExceptionOccurs = $notifyWhenExceptionOccurs;
        return $this;
    }
    /**
     * Get NotifyWhenDeliveryOccurs value
     * @return bool|null
     */
    public function getNotifyWhenDeliveryOccurs()
    {
        return $this->NotifyWhenDeliveryOccurs;
    }
    /**
     * Set NotifyWhenDeliveryOccurs value
     * @param bool $notifyWhenDeliveryOccurs
     * @return \Pepitelabs\PWS\ShippingService\Subscription
     */
    public function setNotifyWhenDeliveryOccurs($notifyWhenDeliveryOccurs = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyWhenDeliveryOccurs) && !is_bool($notifyWhenDeliveryOccurs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notifyWhenDeliveryOccurs, true), gettype($notifyWhenDeliveryOccurs)), __LINE__);
        }
        $this->NotifyWhenDeliveryOccurs = $notifyWhenDeliveryOccurs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\Subscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
