<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnShipmentInformation ShippingService
 * Meta information extracted from the WSDL
 * - documentation: ReturnShipmentInformation
 * - nillable: true
 * - type: tns:ReturnShipmentInformation
 * @subpackage Structs
 */
class ReturnShipmentInformation extends AbstractStructBase
{
    /**
     * The NumberOfReturnShipments
     * Meta information extracted from the WSDL
     * - documentation: NumberOfReturnShipments - int
     * @var int
     */
    public $NumberOfReturnShipments;
    /**
     * The ReturnShipment
     * Meta information extracted from the WSDL
     * - documentation: Shipment - Shipment
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\ReturnShipment
     */
    public $ReturnShipment;
    /**
     * Constructor method for ReturnShipmentInformation
     * @uses ReturnShipmentInformation::setNumberOfReturnShipments()
     * @uses ReturnShipmentInformation::setReturnShipment()
     * @param int $numberOfReturnShipments
     * @param \Pepitelabs\PWS\ShippingService\ReturnShipment $returnShipment
     */
    public function __construct($numberOfReturnShipments = null, \Pepitelabs\PWS\ShippingService\ReturnShipment $returnShipment = null)
    {
        $this
            ->setNumberOfReturnShipments($numberOfReturnShipments)
            ->setReturnShipment($returnShipment);
    }
    /**
     * Get NumberOfReturnShipments value
     * @return int|null
     */
    public function getNumberOfReturnShipments()
    {
        return $this->NumberOfReturnShipments;
    }
    /**
     * Set NumberOfReturnShipments value
     * @param int $numberOfReturnShipments
     * @return \Pepitelabs\PWS\ShippingService\ReturnShipmentInformation
     */
    public function setNumberOfReturnShipments($numberOfReturnShipments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfReturnShipments) && !(is_int($numberOfReturnShipments) || ctype_digit($numberOfReturnShipments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfReturnShipments, true), gettype($numberOfReturnShipments)), __LINE__);
        }
        $this->NumberOfReturnShipments = $numberOfReturnShipments;
        return $this;
    }
    /**
     * Get ReturnShipment value
     * @return \Pepitelabs\PWS\ShippingService\ReturnShipment|null
     */
    public function getReturnShipment()
    {
        return $this->ReturnShipment;
    }
    /**
     * Set ReturnShipment value
     * @param \Pepitelabs\PWS\ShippingService\ReturnShipment $returnShipment
     * @return \Pepitelabs\PWS\ShippingService\ReturnShipmentInformation
     */
    public function setReturnShipment(\Pepitelabs\PWS\ShippingService\ReturnShipment $returnShipment = null)
    {
        $this->ReturnShipment = $returnShipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\ReturnShipmentInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
