<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for PickupType ShippingService
 * Meta information extracted from the WSDL
 * - documentation: PickupType - enum
 * - nillable: true
 * - type: tns:PickupType
 * @subpackage Enumerations
 */
class PickupType
{
    /**
     * Constant for value 'DropOff'
     * Meta information extracted from the WSDL
     * - documentation: DropOff
     * @return string 'DropOff'
     */
    const VALUE_DROP_OFF = 'DropOff';
    /**
     * Constant for value 'PreScheduled'
     * Meta information extracted from the WSDL
     * - documentation: PreScheduled
     * @return string 'PreScheduled'
     */
    const VALUE_PRE_SCHEDULED = 'PreScheduled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DROP_OFF
     * @uses self::VALUE_PRE_SCHEDULED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DROP_OFF,
            self::VALUE_PRE_SCHEDULED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
