<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationInformation ShippingService
 * Meta information extracted from the WSDL
 * - documentation: NotificationInformation
 * - nillable: true
 * - type: tns:NotificationInformation
 * @subpackage Structs
 */
class NotificationInformation extends AbstractStructBase
{
    /**
     * The ConfirmationEmailAddress
     * Meta information extracted from the WSDL
     * - documentation: ConfirmationEmailAddress - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationEmailAddress;
    /**
     * The AdvancedShippingNotificationEmailAddress1
     * Meta information extracted from the WSDL
     * - documentation: AdvancedShippingNotificationEmailAddress1 - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdvancedShippingNotificationEmailAddress1;
    /**
     * The AdvancedShippingNotificationEmailAddress2
     * Meta information extracted from the WSDL
     * - documentation: AdvancedShippingNotificationEmailAddress2 - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdvancedShippingNotificationEmailAddress2;
    /**
     * The AdvancedShippingNotificationMessage
     * Meta information extracted from the WSDL
     * - documentation: AdvancedShippingNotificationMessage - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdvancedShippingNotificationMessage;
    /**
     * Constructor method for NotificationInformation
     * @uses NotificationInformation::setConfirmationEmailAddress()
     * @uses NotificationInformation::setAdvancedShippingNotificationEmailAddress1()
     * @uses NotificationInformation::setAdvancedShippingNotificationEmailAddress2()
     * @uses NotificationInformation::setAdvancedShippingNotificationMessage()
     * @param string $confirmationEmailAddress
     * @param string $advancedShippingNotificationEmailAddress1
     * @param string $advancedShippingNotificationEmailAddress2
     * @param string $advancedShippingNotificationMessage
     */
    public function __construct($confirmationEmailAddress = null, $advancedShippingNotificationEmailAddress1 = null, $advancedShippingNotificationEmailAddress2 = null, $advancedShippingNotificationMessage = null)
    {
        $this
            ->setConfirmationEmailAddress($confirmationEmailAddress)
            ->setAdvancedShippingNotificationEmailAddress1($advancedShippingNotificationEmailAddress1)
            ->setAdvancedShippingNotificationEmailAddress2($advancedShippingNotificationEmailAddress2)
            ->setAdvancedShippingNotificationMessage($advancedShippingNotificationMessage);
    }
    /**
     * Get ConfirmationEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationEmailAddress()
    {
        return isset($this->ConfirmationEmailAddress) ? $this->ConfirmationEmailAddress : null;
    }
    /**
     * Set ConfirmationEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationEmailAddress
     * @return \Pepitelabs\PWS\ShippingService\NotificationInformation
     */
    public function setConfirmationEmailAddress($confirmationEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationEmailAddress) && !is_string($confirmationEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationEmailAddress, true), gettype($confirmationEmailAddress)), __LINE__);
        }
        if (is_null($confirmationEmailAddress) || (is_array($confirmationEmailAddress) && empty($confirmationEmailAddress))) {
            unset($this->ConfirmationEmailAddress);
        } else {
            $this->ConfirmationEmailAddress = $confirmationEmailAddress;
        }
        return $this;
    }
    /**
     * Get AdvancedShippingNotificationEmailAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdvancedShippingNotificationEmailAddress1()
    {
        return isset($this->AdvancedShippingNotificationEmailAddress1) ? $this->AdvancedShippingNotificationEmailAddress1 : null;
    }
    /**
     * Set AdvancedShippingNotificationEmailAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $advancedShippingNotificationEmailAddress1
     * @return \Pepitelabs\PWS\ShippingService\NotificationInformation
     */
    public function setAdvancedShippingNotificationEmailAddress1($advancedShippingNotificationEmailAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($advancedShippingNotificationEmailAddress1) && !is_string($advancedShippingNotificationEmailAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advancedShippingNotificationEmailAddress1, true), gettype($advancedShippingNotificationEmailAddress1)), __LINE__);
        }
        if (is_null($advancedShippingNotificationEmailAddress1) || (is_array($advancedShippingNotificationEmailAddress1) && empty($advancedShippingNotificationEmailAddress1))) {
            unset($this->AdvancedShippingNotificationEmailAddress1);
        } else {
            $this->AdvancedShippingNotificationEmailAddress1 = $advancedShippingNotificationEmailAddress1;
        }
        return $this;
    }
    /**
     * Get AdvancedShippingNotificationEmailAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdvancedShippingNotificationEmailAddress2()
    {
        return isset($this->AdvancedShippingNotificationEmailAddress2) ? $this->AdvancedShippingNotificationEmailAddress2 : null;
    }
    /**
     * Set AdvancedShippingNotificationEmailAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $advancedShippingNotificationEmailAddress2
     * @return \Pepitelabs\PWS\ShippingService\NotificationInformation
     */
    public function setAdvancedShippingNotificationEmailAddress2($advancedShippingNotificationEmailAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($advancedShippingNotificationEmailAddress2) && !is_string($advancedShippingNotificationEmailAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advancedShippingNotificationEmailAddress2, true), gettype($advancedShippingNotificationEmailAddress2)), __LINE__);
        }
        if (is_null($advancedShippingNotificationEmailAddress2) || (is_array($advancedShippingNotificationEmailAddress2) && empty($advancedShippingNotificationEmailAddress2))) {
            unset($this->AdvancedShippingNotificationEmailAddress2);
        } else {
            $this->AdvancedShippingNotificationEmailAddress2 = $advancedShippingNotificationEmailAddress2;
        }
        return $this;
    }
    /**
     * Get AdvancedShippingNotificationMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdvancedShippingNotificationMessage()
    {
        return isset($this->AdvancedShippingNotificationMessage) ? $this->AdvancedShippingNotificationMessage : null;
    }
    /**
     * Set AdvancedShippingNotificationMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $advancedShippingNotificationMessage
     * @return \Pepitelabs\PWS\ShippingService\NotificationInformation
     */
    public function setAdvancedShippingNotificationMessage($advancedShippingNotificationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($advancedShippingNotificationMessage) && !is_string($advancedShippingNotificationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advancedShippingNotificationMessage, true), gettype($advancedShippingNotificationMessage)), __LINE__);
        }
        if (is_null($advancedShippingNotificationMessage) || (is_array($advancedShippingNotificationMessage) && empty($advancedShippingNotificationMessage))) {
            unset($this->AdvancedShippingNotificationMessage);
        } else {
            $this->AdvancedShippingNotificationMessage = $advancedShippingNotificationMessage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\NotificationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
