<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for Language ShippingService
 * Meta information extracted from the WSDL
 * - documentation: Language - enum
 * - nillable: true
 * - type: tns:Language
 * @subpackage Enumerations
 */
class Language
{
    /**
     * Constant for value 'en'
     * Meta information extracted from the WSDL
     * - documentation: en
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Constant for value 'fr'
     * Meta information extracted from the WSDL
     * - documentation: fr
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EN
     * @uses self::VALUE_FR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EN,
            self::VALUE_FR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
