<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for DutyCurrency ShippingService
 * Meta information extracted from the WSDL
 * - documentation: DutyCurrency - enum
 * - nillable: true
 * - type: tns:DutyCurrency
 * @subpackage Enumerations
 */
class DutyCurrency
{
    /**
     * Constant for value 'CAD'
     * Meta information extracted from the WSDL
     * - documentation: CAD
     * @return string 'CAD'
     */
    const VALUE_CAD = 'CAD';
    /**
     * Constant for value 'USD'
     * Meta information extracted from the WSDL
     * - documentation: USD
     * @return string 'USD'
     */
    const VALUE_USD = 'USD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAD
     * @uses self::VALUE_USD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAD,
            self::VALUE_USD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
