<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsolidateResponseContainer ShippingService
 * Meta information extracted from the WSDL
 * - documentation: ValidateShipmentResponse
 * - nillable: true
 * - type: tns:ConsolidateResponseContainer
 * @subpackage Structs
 */
class ConsolidateResponseContainer extends ResponseContainer
{
    /**
     * The Consolidate
     * Meta information extracted from the WSDL
     * - documentation: Consolidate - bool
     * - minOccurs: 0
     * @var bool
     */
    public $Consolidate;
    /**
     * Constructor method for ConsolidateResponseContainer
     * @uses ConsolidateResponseContainer::setConsolidate()
     * @param bool $consolidate
     */
    public function __construct($consolidate = null)
    {
        $this
            ->setConsolidate($consolidate);
    }
    /**
     * Get Consolidate value
     * @return bool|null
     */
    public function getConsolidate()
    {
        return $this->Consolidate;
    }
    /**
     * Set Consolidate value
     * @param bool $consolidate
     * @return \Pepitelabs\PWS\ShippingService\ConsolidateResponseContainer
     */
    public function setConsolidate($consolidate = null)
    {
        // validation for constraint: boolean
        if (!is_null($consolidate) && !is_bool($consolidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consolidate, true), gettype($consolidate)), __LINE__);
        }
        $this->Consolidate = $consolidate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\ConsolidateResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
