<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for BusinessRelationship ShippingService
 * Meta information extracted from the WSDL
 * - documentation: BusinessRelationship - enum
 * - nillable: true
 * - type: tns:BusinessRelationship
 * @subpackage Enumerations
 */
class BusinessRelationship
{
    /**
     * Constant for value 'Related'
     * Meta information extracted from the WSDL
     * - documentation: Related
     * @return string 'Related'
     */
    const VALUE_RELATED = 'Related';
    /**
     * Constant for value 'NotRelated'
     * Meta information extracted from the WSDL
     * - documentation: NotRelated
     * @return string 'NotRelated'
     */
    const VALUE_NOT_RELATED = 'NotRelated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RELATED
     * @uses self::VALUE_NOT_RELATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RELATED,
            self::VALUE_NOT_RELATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
