<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubscription ShippingService
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSubscription
 * @subpackage Arrays
 */
class ArrayOfSubscription extends AbstractStructArrayBase
{
    /**
     * The Subscription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Subscription[]
     */
    public $Subscription;
    /**
     * Constructor method for ArrayOfSubscription
     * @uses ArrayOfSubscription::setSubscription()
     * @param \Pepitelabs\PWS\ShippingService\Subscription[] $subscription
     */
    public function __construct(array $subscription = array())
    {
        $this
            ->setSubscription($subscription);
    }
    /**
     * Get Subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\Subscription[]|null
     */
    public function getSubscription()
    {
        return isset($this->Subscription) ? $this->Subscription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionForArrayConstraintsFromSetSubscription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSubscriptionSubscriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubscriptionSubscriptionItem instanceof \Pepitelabs\PWS\ShippingService\Subscription) {
                $invalidValues[] = is_object($arrayOfSubscriptionSubscriptionItem) ? get_class($arrayOfSubscriptionSubscriptionItem) : sprintf('%s(%s)', gettype($arrayOfSubscriptionSubscriptionItem), var_export($arrayOfSubscriptionSubscriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Subscription property can only contain items of type \Pepitelabs\PWS\ShippingService\Subscription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pepitelabs\PWS\ShippingService\Subscription[] $subscription
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfSubscription
     */
    public function setSubscription(array $subscription = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionArrayErrorMessage = self::validateSubscriptionForArrayConstraintsFromSetSubscription($subscription))) {
            throw new \InvalidArgumentException($subscriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($subscription) || (is_array($subscription) && empty($subscription))) {
            unset($this->Subscription);
        } else {
            $this->Subscription = $subscription;
        }
        return $this;
    }
    /**
     * Add item to Subscription value
     * @throws \InvalidArgumentException
     * @param \Pepitelabs\PWS\ShippingService\Subscription $item
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfSubscription
     */
    public function addToSubscription(\Pepitelabs\PWS\ShippingService\Subscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pepitelabs\PWS\ShippingService\Subscription) {
            throw new \InvalidArgumentException(sprintf('The Subscription property can only contain items of type \Pepitelabs\PWS\ShippingService\Subscription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Subscription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pepitelabs\PWS\ShippingService\Subscription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pepitelabs\PWS\ShippingService\Subscription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pepitelabs\PWS\ShippingService\Subscription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pepitelabs\PWS\ShippingService\Subscription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pepitelabs\PWS\ShippingService\Subscription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Subscription
     */
    public function getAttributeName()
    {
        return 'Subscription';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
