<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address ShippingService
 * Meta information extracted from the WSDL
 * - documentation: Address
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name - string
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Company - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The Department
     * Meta information extracted from the WSDL
     * - documentation: Department - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Department;
    /**
     * The StreetNumber
     * Meta information extracted from the WSDL
     * - documentation: StreetNumber - string
     * - nillable: true
     * @var string
     */
    public $StreetNumber;
    /**
     * The StreetSuffix
     * Meta information extracted from the WSDL
     * - documentation: StreetSuffix - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetSuffix;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - documentation: StreetName - string
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetType
     * Meta information extracted from the WSDL
     * - documentation: StreetType - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetType;
    /**
     * The StreetDirection
     * Meta information extracted from the WSDL
     * - documentation: StreetDirection - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetDirection;
    /**
     * The Suite
     * Meta information extracted from the WSDL
     * - documentation: Suite - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suite;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - documentation: Floor - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Floor;
    /**
     * The StreetAddress2
     * Meta information extracted from the WSDL
     * - documentation: StreetAddress2 - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress2;
    /**
     * The StreetAddress3
     * Meta information extracted from the WSDL
     * - documentation: StreetAddress3 - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress3;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City - string
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - documentation: Province - string
     * - nillable: true
     * @var string
     */
    public $Province;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: Country - string
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: PostalCode - string
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: PhoneNumber - PhoneNumber
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\PhoneNumber
     */
    public $PhoneNumber;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - documentation: Faxnumber - PhoneNumber
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\PhoneNumber
     */
    public $FaxNumber;
    /**
     * Constructor method for Address
     * @uses Address::setName()
     * @uses Address::setCompany()
     * @uses Address::setDepartment()
     * @uses Address::setStreetNumber()
     * @uses Address::setStreetSuffix()
     * @uses Address::setStreetName()
     * @uses Address::setStreetType()
     * @uses Address::setStreetDirection()
     * @uses Address::setSuite()
     * @uses Address::setFloor()
     * @uses Address::setStreetAddress2()
     * @uses Address::setStreetAddress3()
     * @uses Address::setCity()
     * @uses Address::setProvince()
     * @uses Address::setCountry()
     * @uses Address::setPostalCode()
     * @uses Address::setPhoneNumber()
     * @uses Address::setFaxNumber()
     * @param string $name
     * @param string $company
     * @param string $department
     * @param string $streetNumber
     * @param string $streetSuffix
     * @param string $streetName
     * @param string $streetType
     * @param string $streetDirection
     * @param string $suite
     * @param string $floor
     * @param string $streetAddress2
     * @param string $streetAddress3
     * @param string $city
     * @param string $province
     * @param string $country
     * @param string $postalCode
     * @param \Pepitelabs\PWS\ShippingService\PhoneNumber $phoneNumber
     * @param \Pepitelabs\PWS\ShippingService\PhoneNumber $faxNumber
     */
    public function __construct($name = null, $company = null, $department = null, $streetNumber = null, $streetSuffix = null, $streetName = null, $streetType = null, $streetDirection = null, $suite = null, $floor = null, $streetAddress2 = null, $streetAddress3 = null, $city = null, $province = null, $country = null, $postalCode = null, \Pepitelabs\PWS\ShippingService\PhoneNumber $phoneNumber = null, \Pepitelabs\PWS\ShippingService\PhoneNumber $faxNumber = null)
    {
        $this
            ->setName($name)
            ->setCompany($company)
            ->setDepartment($department)
            ->setStreetNumber($streetNumber)
            ->setStreetSuffix($streetSuffix)
            ->setStreetName($streetName)
            ->setStreetType($streetType)
            ->setStreetDirection($streetDirection)
            ->setSuite($suite)
            ->setFloor($floor)
            ->setStreetAddress2($streetAddress2)
            ->setStreetAddress3($streetAddress3)
            ->setCity($city)
            ->setProvince($province)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setPhoneNumber($phoneNumber)
            ->setFaxNumber($faxNumber);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $department
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get StreetSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return isset($this->StreetSuffix) ? $this->StreetSuffix : null;
    }
    /**
     * Set StreetSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetSuffix
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($streetSuffix) && !is_string($streetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetSuffix, true), gettype($streetSuffix)), __LINE__);
        }
        if (is_null($streetSuffix) || (is_array($streetSuffix) && empty($streetSuffix))) {
            unset($this->StreetSuffix);
        } else {
            $this->StreetSuffix = $streetSuffix;
        }
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetType()
    {
        return isset($this->StreetType) ? $this->StreetType : null;
    }
    /**
     * Set StreetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetType
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetType($streetType = null)
    {
        // validation for constraint: string
        if (!is_null($streetType) && !is_string($streetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetType, true), gettype($streetType)), __LINE__);
        }
        if (is_null($streetType) || (is_array($streetType) && empty($streetType))) {
            unset($this->StreetType);
        } else {
            $this->StreetType = $streetType;
        }
        return $this;
    }
    /**
     * Get StreetDirection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetDirection()
    {
        return isset($this->StreetDirection) ? $this->StreetDirection : null;
    }
    /**
     * Set StreetDirection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetDirection
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetDirection($streetDirection = null)
    {
        // validation for constraint: string
        if (!is_null($streetDirection) && !is_string($streetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetDirection, true), gettype($streetDirection)), __LINE__);
        }
        if (is_null($streetDirection) || (is_array($streetDirection) && empty($streetDirection))) {
            unset($this->StreetDirection);
        } else {
            $this->StreetDirection = $streetDirection;
        }
        return $this;
    }
    /**
     * Get Suite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuite()
    {
        return isset($this->Suite) ? $this->Suite : null;
    }
    /**
     * Set Suite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suite
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setSuite($suite = null)
    {
        // validation for constraint: string
        if (!is_null($suite) && !is_string($suite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suite, true), gettype($suite)), __LINE__);
        }
        if (is_null($suite) || (is_array($suite) && empty($suite))) {
            unset($this->Suite);
        } else {
            $this->Suite = $suite;
        }
        return $this;
    }
    /**
     * Get Floor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFloor()
    {
        return isset($this->Floor) ? $this->Floor : null;
    }
    /**
     * Set Floor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $floor
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        if (is_null($floor) || (is_array($floor) && empty($floor))) {
            unset($this->Floor);
        } else {
            $this->Floor = $floor;
        }
        return $this;
    }
    /**
     * Get StreetAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress2()
    {
        return isset($this->StreetAddress2) ? $this->StreetAddress2 : null;
    }
    /**
     * Set StreetAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress2
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetAddress2($streetAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress2) && !is_string($streetAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress2, true), gettype($streetAddress2)), __LINE__);
        }
        if (is_null($streetAddress2) || (is_array($streetAddress2) && empty($streetAddress2))) {
            unset($this->StreetAddress2);
        } else {
            $this->StreetAddress2 = $streetAddress2;
        }
        return $this;
    }
    /**
     * Get StreetAddress3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress3()
    {
        return isset($this->StreetAddress3) ? $this->StreetAddress3 : null;
    }
    /**
     * Set StreetAddress3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress3
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setStreetAddress3($streetAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress3) && !is_string($streetAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress3, true), gettype($streetAddress3)), __LINE__);
        }
        if (is_null($streetAddress3) || (is_array($streetAddress3) && empty($streetAddress3))) {
            unset($this->StreetAddress3);
        } else {
            $this->StreetAddress3 = $streetAddress3;
        }
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->Province;
    }
    /**
     * Set Province value
     * @param string $province
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        $this->Province = $province;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \Pepitelabs\PWS\ShippingService\PhoneNumber|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param \Pepitelabs\PWS\ShippingService\PhoneNumber $phoneNumber
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setPhoneNumber(\Pepitelabs\PWS\ShippingService\PhoneNumber $phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\PhoneNumber|null
     */
    public function getFaxNumber()
    {
        return isset($this->FaxNumber) ? $this->FaxNumber : null;
    }
    /**
     * Set FaxNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\PhoneNumber $faxNumber
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public function setFaxNumber(\Pepitelabs\PWS\ShippingService\PhoneNumber $faxNumber = null)
    {
        if (is_null($faxNumber) || (is_array($faxNumber) && empty($faxNumber))) {
            unset($this->FaxNumber);
        } else {
            $this->FaxNumber = $faxNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
