<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pepitelabs\PWS\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \Pepitelabs\PWS\ShippingService\Create($options);
$create->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ShippingService\RequestContext());
/**
 * Sample call for CreateShipment operation/method
 */
if ($create->CreateShipment(new \Pepitelabs\PWS\ShippingService\CreateShipmentRequestContainer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \Pepitelabs\PWS\ShippingService\_Void($options);
$void->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ShippingService\RequestContext());
/**
 * Sample call for VoidShipment operation/method
 */
if ($void->VoidShipment(new \Pepitelabs\PWS\ShippingService\VoidShipmentRequestContainer()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \Pepitelabs\PWS\ShippingService\Validate($options);
$validate->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ShippingService\RequestContext());
/**
 * Sample call for ValidateShipment operation/method
 */
if ($validate->ValidateShipment(new \Pepitelabs\PWS\ShippingService\ValidateShipmentRequestContainer()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Consolidate ServiceType
 */
$consolidate = new \Pepitelabs\PWS\ShippingService\Consolidate($options);
$consolidate->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ShippingService\RequestContext());
/**
 * Sample call for Consolidate operation/method
 */
if ($consolidate->Consolidate(new \Pepitelabs\PWS\ShippingService\ConsolidateRequestContainer()) !== false) {
    print_r($consolidate->getResult());
} else {
    print_r($consolidate->getLastError());
}
