<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Void ShippingService
 * @subpackage Services
 */
class _Void extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\ShippingService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\ShippingService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named VoidShipment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ShippingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: VoidShipment @param request VoidShipmentRequest @return VoidShipmentResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ShippingService\VoidShipmentRequestContainer $voidShipmentRequest
     * @return \Pepitelabs\PWS\ShippingService\VoidShipmentResponseContainer|bool
     */
    public function VoidShipment(\Pepitelabs\PWS\ShippingService\VoidShipmentRequestContainer $voidShipmentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->VoidShipment($voidShipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\ShippingService\VoidShipmentResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
