<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Weight ShippingService
 * Meta information extracted from the WSDL
 * - documentation: Weight
 * - nillable: true
 * - type: tns:Weight
 * @subpackage Structs
 */
class Weight extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Value - decimal
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The WeightUnit
     * Meta information extracted from the WSDL
     * - documentation: WeightUnit - WeightUnit
     * @var string
     */
    public $WeightUnit;
    /**
     * Constructor method for Weight
     * @uses Weight::setValue()
     * @uses Weight::setWeightUnit()
     * @param float $value
     * @param string $weightUnit
     */
    public function __construct($value = null, $weightUnit = null)
    {
        $this
            ->setValue($value)
            ->setWeightUnit($weightUnit);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \Pepitelabs\PWS\ShippingService\Weight
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @uses \Pepitelabs\PWS\ShippingService\WeightUnit::valueIsValid()
     * @uses \Pepitelabs\PWS\ShippingService\WeightUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightUnit
     * @return \Pepitelabs\PWS\ShippingService\Weight
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ShippingService\WeightUnit::valueIsValid($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ShippingService\WeightUnit', is_array($weightUnit) ? implode(', ', $weightUnit) : var_export($weightUnit, true), implode(', ', \Pepitelabs\PWS\ShippingService\WeightUnit::getValidValues())), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\Weight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
