<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiverInformation ShippingService
 * Meta information extracted from the WSDL
 * - documentation: ReceiverInformation
 * - nillable: true
 * - type: tns:ReceiverInformation
 * @subpackage Structs
 */
class ReceiverInformation extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Address
     */
    public $Address;
    /**
     * The TaxNumber
     * Meta information extracted from the WSDL
     * - documentation: TaxNumber - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxNumber;
    /**
     * Constructor method for ReceiverInformation
     * @uses ReceiverInformation::setAddress()
     * @uses ReceiverInformation::setTaxNumber()
     * @param \Pepitelabs\PWS\ShippingService\Address $address
     * @param string $taxNumber
     */
    public function __construct(\Pepitelabs\PWS\ShippingService\Address $address = null, $taxNumber = null)
    {
        $this
            ->setAddress($address)
            ->setTaxNumber($taxNumber);
    }
    /**
     * Get Address value
     * @return \Pepitelabs\PWS\ShippingService\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Pepitelabs\PWS\ShippingService\Address $address
     * @return \Pepitelabs\PWS\ShippingService\ReceiverInformation
     */
    public function setAddress(\Pepitelabs\PWS\ShippingService\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get TaxNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxNumber()
    {
        return isset($this->TaxNumber) ? $this->TaxNumber : null;
    }
    /**
     * Set TaxNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxNumber
     * @return \Pepitelabs\PWS\ShippingService\ReceiverInformation
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumber, true), gettype($taxNumber)), __LINE__);
        }
        if (is_null($taxNumber) || (is_array($taxNumber) && empty($taxNumber))) {
            unset($this->TaxNumber);
        } else {
            $this->TaxNumber = $taxNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\ReceiverInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
