<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for PrinterType ShippingService
 * Meta information extracted from the WSDL
 * - documentation: PrinterType - enum
 * - nillable: true
 * - type: tns:PrinterType
 * @subpackage Enumerations
 */
class PrinterType
{
    /**
     * Constant for value 'Regular'
     * Meta information extracted from the WSDL
     * - documentation: Regular
     * @return string 'Regular'
     */
    const VALUE_REGULAR = 'Regular';
    /**
     * Constant for value 'Thermal'
     * Meta information extracted from the WSDL
     * - documentation: Thermal
     * @return string 'Thermal'
     */
    const VALUE_THERMAL = 'Thermal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR
     * @uses self::VALUE_THERMAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR,
            self::VALUE_THERMAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
