<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Piece ShippingService
 * Meta information extracted from the WSDL
 * - documentation: Piece
 * - nillable: true
 * - type: tns:Piece
 * @subpackage Structs
 */
class Piece extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: Weight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Weight
     */
    public $Weight;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Length - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Dimension
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Width - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Dimension
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Height - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Dimension
     */
    public $Height;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - documentation: Options - OptionIDValuePair[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair
     */
    public $Options;
    /**
     * Constructor method for Piece
     * @uses Piece::setWeight()
     * @uses Piece::setLength()
     * @uses Piece::setWidth()
     * @uses Piece::setHeight()
     * @uses Piece::setOptions()
     * @param \Pepitelabs\PWS\ShippingService\Weight $weight
     * @param \Pepitelabs\PWS\ShippingService\Dimension $length
     * @param \Pepitelabs\PWS\ShippingService\Dimension $width
     * @param \Pepitelabs\PWS\ShippingService\Dimension $height
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair $options
     */
    public function __construct(\Pepitelabs\PWS\ShippingService\Weight $weight = null, \Pepitelabs\PWS\ShippingService\Dimension $length = null, \Pepitelabs\PWS\ShippingService\Dimension $width = null, \Pepitelabs\PWS\ShippingService\Dimension $height = null, \Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair $options = null)
    {
        $this
            ->setWeight($weight)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setOptions($options);
    }
    /**
     * Get Weight value
     * @return \Pepitelabs\PWS\ShippingService\Weight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \Pepitelabs\PWS\ShippingService\Weight $weight
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public function setWeight(\Pepitelabs\PWS\ShippingService\Weight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\Dimension|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\Dimension $length
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public function setLength(\Pepitelabs\PWS\ShippingService\Dimension $length = null)
    {
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\Dimension|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\Dimension $width
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public function setWidth(\Pepitelabs\PWS\ShippingService\Dimension $width = null)
    {
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\Dimension|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\Dimension $height
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public function setHeight(\Pepitelabs\PWS\ShippingService\Dimension $height = null)
    {
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair $options
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public function setOptions(\Pepitelabs\PWS\ShippingService\ArrayOfOptionIDValuePair $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\Piece
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
