<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for PaymentType ShippingService
 * Meta information extracted from the WSDL
 * - documentation: PaymentType - enum
 * - nillable: true
 * - type: tns:PaymentType
 * @subpackage Enumerations
 */
class PaymentType
{
    /**
     * Constant for value 'Sender'
     * Meta information extracted from the WSDL
     * - documentation: Sender
     * @return string 'Sender'
     */
    const VALUE_SENDER = 'Sender';
    /**
     * Constant for value 'Receiver'
     * Meta information extracted from the WSDL
     * - documentation: Receiver
     * @return string 'Receiver'
     */
    const VALUE_RECEIVER = 'Receiver';
    /**
     * Constant for value 'ThirdParty'
     * Meta information extracted from the WSDL
     * - documentation: ThirdParty
     * @return string 'ThirdParty'
     */
    const VALUE_THIRD_PARTY = 'ThirdParty';
    /**
     * Constant for value 'CreditCard'
     * Meta information extracted from the WSDL
     * - documentation: CreditCard
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SENDER
     * @uses self::VALUE_RECEIVER
     * @uses self::VALUE_THIRD_PARTY
     * @uses self::VALUE_CREDIT_CARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SENDER,
            self::VALUE_RECEIVER,
            self::VALUE_THIRD_PARTY,
            self::VALUE_CREDIT_CARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
