<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionIDValuePair ShippingService
 * Meta information extracted from the WSDL
 * - documentation: OptionIDValuePair
 * - nillable: true
 * - type: tns:OptionIDValuePair
 * @subpackage Structs
 */
class OptionIDValuePair extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: ID - string
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Value - string
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for OptionIDValuePair
     * @uses OptionIDValuePair::setID()
     * @uses OptionIDValuePair::setValue()
     * @param string $iD
     * @param string $value
     */
    public function __construct($iD = null, $value = null)
    {
        $this
            ->setID($iD)
            ->setValue($value);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Pepitelabs\PWS\ShippingService\OptionIDValuePair
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Pepitelabs\PWS\ShippingService\OptionIDValuePair
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\OptionIDValuePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
