<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateShipmentResponseContainer ShippingService
 * Meta information extracted from the WSDL
 * - documentation: CreateShipmentResponse
 * - nillable: true
 * - type: tns:CreateShipmentResponseContainer
 * @subpackage Structs
 */
class CreateShipmentResponseContainer extends ResponseContainer
{
    /**
     * The ShipmentPIN
     * Meta information extracted from the WSDL
     * - documentation: ShipmentPIN - PIN
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\PIN
     */
    public $ShipmentPIN;
    /**
     * The PiecePINs
     * Meta information extracted from the WSDL
     * - documentation: PiecePINs - PIN[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\ArrayOfPIN
     */
    public $PiecePINs;
    /**
     * The ReturnShipmentPINs
     * Meta information extracted from the WSDL
     * - documentation: ReturnShipmentPINs - PIN[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\ArrayOfPIN
     */
    public $ReturnShipmentPINs;
    /**
     * The ExpressChequePIN
     * Meta information extracted from the WSDL
     * - documentation: ExpressChequePIN - PIN
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\PIN
     */
    public $ExpressChequePIN;
    /**
     * Constructor method for CreateShipmentResponseContainer
     * @uses CreateShipmentResponseContainer::setShipmentPIN()
     * @uses CreateShipmentResponseContainer::setPiecePINs()
     * @uses CreateShipmentResponseContainer::setReturnShipmentPINs()
     * @uses CreateShipmentResponseContainer::setExpressChequePIN()
     * @param \Pepitelabs\PWS\ShippingService\PIN $shipmentPIN
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfPIN $piecePINs
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfPIN $returnShipmentPINs
     * @param \Pepitelabs\PWS\ShippingService\PIN $expressChequePIN
     */
    public function __construct(\Pepitelabs\PWS\ShippingService\PIN $shipmentPIN = null, \Pepitelabs\PWS\ShippingService\ArrayOfPIN $piecePINs = null, \Pepitelabs\PWS\ShippingService\ArrayOfPIN $returnShipmentPINs = null, \Pepitelabs\PWS\ShippingService\PIN $expressChequePIN = null)
    {
        $this
            ->setShipmentPIN($shipmentPIN)
            ->setPiecePINs($piecePINs)
            ->setReturnShipmentPINs($returnShipmentPINs)
            ->setExpressChequePIN($expressChequePIN);
    }
    /**
     * Get ShipmentPIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\PIN|null
     */
    public function getShipmentPIN()
    {
        return isset($this->ShipmentPIN) ? $this->ShipmentPIN : null;
    }
    /**
     * Set ShipmentPIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\PIN $shipmentPIN
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentResponseContainer
     */
    public function setShipmentPIN(\Pepitelabs\PWS\ShippingService\PIN $shipmentPIN = null)
    {
        if (is_null($shipmentPIN) || (is_array($shipmentPIN) && empty($shipmentPIN))) {
            unset($this->ShipmentPIN);
        } else {
            $this->ShipmentPIN = $shipmentPIN;
        }
        return $this;
    }
    /**
     * Get PiecePINs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfPIN|null
     */
    public function getPiecePINs()
    {
        return isset($this->PiecePINs) ? $this->PiecePINs : null;
    }
    /**
     * Set PiecePINs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfPIN $piecePINs
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentResponseContainer
     */
    public function setPiecePINs(\Pepitelabs\PWS\ShippingService\ArrayOfPIN $piecePINs = null)
    {
        if (is_null($piecePINs) || (is_array($piecePINs) && empty($piecePINs))) {
            unset($this->PiecePINs);
        } else {
            $this->PiecePINs = $piecePINs;
        }
        return $this;
    }
    /**
     * Get ReturnShipmentPINs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\ArrayOfPIN|null
     */
    public function getReturnShipmentPINs()
    {
        return isset($this->ReturnShipmentPINs) ? $this->ReturnShipmentPINs : null;
    }
    /**
     * Set ReturnShipmentPINs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\ArrayOfPIN $returnShipmentPINs
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentResponseContainer
     */
    public function setReturnShipmentPINs(\Pepitelabs\PWS\ShippingService\ArrayOfPIN $returnShipmentPINs = null)
    {
        if (is_null($returnShipmentPINs) || (is_array($returnShipmentPINs) && empty($returnShipmentPINs))) {
            unset($this->ReturnShipmentPINs);
        } else {
            $this->ReturnShipmentPINs = $returnShipmentPINs;
        }
        return $this;
    }
    /**
     * Get ExpressChequePIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ShippingService\PIN|null
     */
    public function getExpressChequePIN()
    {
        return isset($this->ExpressChequePIN) ? $this->ExpressChequePIN : null;
    }
    /**
     * Set ExpressChequePIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ShippingService\PIN $expressChequePIN
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentResponseContainer
     */
    public function setExpressChequePIN(\Pepitelabs\PWS\ShippingService\PIN $expressChequePIN = null)
    {
        if (is_null($expressChequePIN) || (is_array($expressChequePIN) && empty($expressChequePIN))) {
            unset($this->ExpressChequePIN);
        } else {
            $this->ExpressChequePIN = $expressChequePIN;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
