<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateShipmentRequestContainer ShippingService
 * Meta information extracted from the WSDL
 * - documentation: CreateShipmentRequest
 * - nillable: true
 * - type: tns:CreateShipmentRequestContainer
 * @subpackage Structs
 */
class CreateShipmentRequestContainer extends RequestContainer
{
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - documentation: Shipment - Shipment
     * - nillable: true
     * @var \Pepitelabs\PWS\ShippingService\Shipment
     */
    public $Shipment;
    /**
     * The PrinterType
     * Meta information extracted from the WSDL
     * - documentation: PrinterType - PrinterType
     * - nillable: true
     * @var string
     */
    public $PrinterType;
    /**
     * Constructor method for CreateShipmentRequestContainer
     * @uses CreateShipmentRequestContainer::setShipment()
     * @uses CreateShipmentRequestContainer::setPrinterType()
     * @param \Pepitelabs\PWS\ShippingService\Shipment $shipment
     * @param string $printerType
     */
    public function __construct(\Pepitelabs\PWS\ShippingService\Shipment $shipment = null, $printerType = null)
    {
        $this
            ->setShipment($shipment)
            ->setPrinterType($printerType);
    }
    /**
     * Get Shipment value
     * @return \Pepitelabs\PWS\ShippingService\Shipment|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Pepitelabs\PWS\ShippingService\Shipment $shipment
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentRequestContainer
     */
    public function setShipment(\Pepitelabs\PWS\ShippingService\Shipment $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get PrinterType value
     * @return string|null
     */
    public function getPrinterType()
    {
        return $this->PrinterType;
    }
    /**
     * Set PrinterType value
     * @uses \Pepitelabs\PWS\ShippingService\PrinterType::valueIsValid()
     * @uses \Pepitelabs\PWS\ShippingService\PrinterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printerType
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentRequestContainer
     */
    public function setPrinterType($printerType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ShippingService\PrinterType::valueIsValid($printerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ShippingService\PrinterType', is_array($printerType) ? implode(', ', $printerType) : var_export($printerType, true), implode(', ', \Pepitelabs\PWS\ShippingService\PrinterType::getValidValues())), __LINE__);
        }
        $this->PrinterType = $printerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\CreateShipmentRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
