<?php

namespace Pepitelabs\PWS\ShippingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentDetail ShippingService
 * Meta information extracted from the WSDL
 * - documentation: ContentDetail
 * - nillable: true
 * - type: tns:ContentDetail
 * @subpackage Structs
 */
class ContentDetail extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The HarmonizedCode
     * Meta information extracted from the WSDL
     * - documentation: HarmonizedCode - string
     * - nillable: true
     * @var string
     */
    public $HarmonizedCode;
    /**
     * The CountryOfManufacture
     * Meta information extracted from the WSDL
     * - documentation: CountryOfManufacture - string
     * - nillable: true
     * @var string
     */
    public $CountryOfManufacture;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - documentation: ProductCode - string
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The UnitValue
     * Meta information extracted from the WSDL
     * - documentation: UnitValue - decimal
     * @var float
     */
    public $UnitValue;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Quantity - int
     * @var int
     */
    public $Quantity;
    /**
     * The NAFTADocumentIndicator
     * Meta information extracted from the WSDL
     * - documentation: NAFTADocumentIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $NAFTADocumentIndicator;
    /**
     * The FDADocumentIndicator
     * Meta information extracted from the WSDL
     * - documentation: FDADocumentIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $FDADocumentIndicator;
    /**
     * The FCCDocumentIndicator
     * Meta information extracted from the WSDL
     * - documentation: FCCDocumentIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $FCCDocumentIndicator;
    /**
     * The SenderIsProducerIndicator
     * Meta information extracted from the WSDL
     * - documentation: SenderIsProducerIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $SenderIsProducerIndicator;
    /**
     * The TextileIndicator
     * Meta information extracted from the WSDL
     * - documentation: TextileIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $TextileIndicator;
    /**
     * The TextileManufacturer
     * Meta information extracted from the WSDL
     * - documentation: ProductCode - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextileManufacturer;
    /**
     * Constructor method for ContentDetail
     * @uses ContentDetail::setDescription()
     * @uses ContentDetail::setHarmonizedCode()
     * @uses ContentDetail::setCountryOfManufacture()
     * @uses ContentDetail::setProductCode()
     * @uses ContentDetail::setUnitValue()
     * @uses ContentDetail::setQuantity()
     * @uses ContentDetail::setNAFTADocumentIndicator()
     * @uses ContentDetail::setFDADocumentIndicator()
     * @uses ContentDetail::setFCCDocumentIndicator()
     * @uses ContentDetail::setSenderIsProducerIndicator()
     * @uses ContentDetail::setTextileIndicator()
     * @uses ContentDetail::setTextileManufacturer()
     * @param string $description
     * @param string $harmonizedCode
     * @param string $countryOfManufacture
     * @param string $productCode
     * @param float $unitValue
     * @param int $quantity
     * @param bool $nAFTADocumentIndicator
     * @param bool $fDADocumentIndicator
     * @param bool $fCCDocumentIndicator
     * @param bool $senderIsProducerIndicator
     * @param bool $textileIndicator
     * @param string $textileManufacturer
     */
    public function __construct($description = null, $harmonizedCode = null, $countryOfManufacture = null, $productCode = null, $unitValue = null, $quantity = null, $nAFTADocumentIndicator = null, $fDADocumentIndicator = null, $fCCDocumentIndicator = null, $senderIsProducerIndicator = null, $textileIndicator = null, $textileManufacturer = null)
    {
        $this
            ->setDescription($description)
            ->setHarmonizedCode($harmonizedCode)
            ->setCountryOfManufacture($countryOfManufacture)
            ->setProductCode($productCode)
            ->setUnitValue($unitValue)
            ->setQuantity($quantity)
            ->setNAFTADocumentIndicator($nAFTADocumentIndicator)
            ->setFDADocumentIndicator($fDADocumentIndicator)
            ->setFCCDocumentIndicator($fCCDocumentIndicator)
            ->setSenderIsProducerIndicator($senderIsProducerIndicator)
            ->setTextileIndicator($textileIndicator)
            ->setTextileManufacturer($textileManufacturer);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get HarmonizedCode value
     * @return string|null
     */
    public function getHarmonizedCode()
    {
        return $this->HarmonizedCode;
    }
    /**
     * Set HarmonizedCode value
     * @param string $harmonizedCode
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setHarmonizedCode($harmonizedCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonizedCode) && !is_string($harmonizedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harmonizedCode, true), gettype($harmonizedCode)), __LINE__);
        }
        $this->HarmonizedCode = $harmonizedCode;
        return $this;
    }
    /**
     * Get CountryOfManufacture value
     * @return string|null
     */
    public function getCountryOfManufacture()
    {
        return $this->CountryOfManufacture;
    }
    /**
     * Set CountryOfManufacture value
     * @param string $countryOfManufacture
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setCountryOfManufacture($countryOfManufacture = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfManufacture) && !is_string($countryOfManufacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfManufacture, true), gettype($countryOfManufacture)), __LINE__);
        }
        $this->CountryOfManufacture = $countryOfManufacture;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get UnitValue value
     * @return float|null
     */
    public function getUnitValue()
    {
        return $this->UnitValue;
    }
    /**
     * Set UnitValue value
     * @param float $unitValue
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setUnitValue($unitValue = null)
    {
        // validation for constraint: float
        if (!is_null($unitValue) && !(is_float($unitValue) || is_numeric($unitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitValue, true), gettype($unitValue)), __LINE__);
        }
        $this->UnitValue = $unitValue;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get NAFTADocumentIndicator value
     * @return bool|null
     */
    public function getNAFTADocumentIndicator()
    {
        return $this->NAFTADocumentIndicator;
    }
    /**
     * Set NAFTADocumentIndicator value
     * @param bool $nAFTADocumentIndicator
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setNAFTADocumentIndicator($nAFTADocumentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nAFTADocumentIndicator) && !is_bool($nAFTADocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nAFTADocumentIndicator, true), gettype($nAFTADocumentIndicator)), __LINE__);
        }
        $this->NAFTADocumentIndicator = $nAFTADocumentIndicator;
        return $this;
    }
    /**
     * Get FDADocumentIndicator value
     * @return bool|null
     */
    public function getFDADocumentIndicator()
    {
        return $this->FDADocumentIndicator;
    }
    /**
     * Set FDADocumentIndicator value
     * @param bool $fDADocumentIndicator
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setFDADocumentIndicator($fDADocumentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fDADocumentIndicator) && !is_bool($fDADocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fDADocumentIndicator, true), gettype($fDADocumentIndicator)), __LINE__);
        }
        $this->FDADocumentIndicator = $fDADocumentIndicator;
        return $this;
    }
    /**
     * Get FCCDocumentIndicator value
     * @return bool|null
     */
    public function getFCCDocumentIndicator()
    {
        return $this->FCCDocumentIndicator;
    }
    /**
     * Set FCCDocumentIndicator value
     * @param bool $fCCDocumentIndicator
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setFCCDocumentIndicator($fCCDocumentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fCCDocumentIndicator) && !is_bool($fCCDocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fCCDocumentIndicator, true), gettype($fCCDocumentIndicator)), __LINE__);
        }
        $this->FCCDocumentIndicator = $fCCDocumentIndicator;
        return $this;
    }
    /**
     * Get SenderIsProducerIndicator value
     * @return bool|null
     */
    public function getSenderIsProducerIndicator()
    {
        return $this->SenderIsProducerIndicator;
    }
    /**
     * Set SenderIsProducerIndicator value
     * @param bool $senderIsProducerIndicator
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setSenderIsProducerIndicator($senderIsProducerIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($senderIsProducerIndicator) && !is_bool($senderIsProducerIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($senderIsProducerIndicator, true), gettype($senderIsProducerIndicator)), __LINE__);
        }
        $this->SenderIsProducerIndicator = $senderIsProducerIndicator;
        return $this;
    }
    /**
     * Get TextileIndicator value
     * @return bool|null
     */
    public function getTextileIndicator()
    {
        return $this->TextileIndicator;
    }
    /**
     * Set TextileIndicator value
     * @param bool $textileIndicator
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setTextileIndicator($textileIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($textileIndicator) && !is_bool($textileIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($textileIndicator, true), gettype($textileIndicator)), __LINE__);
        }
        $this->TextileIndicator = $textileIndicator;
        return $this;
    }
    /**
     * Get TextileManufacturer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextileManufacturer()
    {
        return isset($this->TextileManufacturer) ? $this->TextileManufacturer : null;
    }
    /**
     * Set TextileManufacturer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textileManufacturer
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public function setTextileManufacturer($textileManufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($textileManufacturer) && !is_string($textileManufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textileManufacturer, true), gettype($textileManufacturer)), __LINE__);
        }
        if (is_null($textileManufacturer) || (is_array($textileManufacturer) && empty($textileManufacturer))) {
            unset($this->TextileManufacturer);
        } else {
            $this->TextileManufacturer = $textileManufacturer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ShippingService\ContentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
