<?php

namespace Pepitelabs\PWS\ShippingService;

/**
 * This class stands for BillDutiesToParty ShippingService
 * Meta information extracted from the WSDL
 * - documentation: BillDutiesToParty - enum
 * - nillable: true
 * - type: tns:BillDutiesToParty
 * @subpackage Enumerations
 */
class BillDutiesToParty
{
    /**
     * Constant for value 'Sender'
     * Meta information extracted from the WSDL
     * - documentation: Sender
     * @return string 'Sender'
     */
    const VALUE_SENDER = 'Sender';
    /**
     * Constant for value 'Receiver'
     * Meta information extracted from the WSDL
     * - documentation: Receiver
     * @return string 'Receiver'
     */
    const VALUE_RECEIVER = 'Receiver';
    /**
     * Constant for value 'Buyer'
     * Meta information extracted from the WSDL
     * - documentation: Buyer
     * @return string 'Buyer'
     */
    const VALUE_BUYER = 'Buyer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SENDER
     * @uses self::VALUE_RECEIVER
     * @uses self::VALUE_BUYER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SENDER,
            self::VALUE_RECEIVER,
            self::VALUE_BUYER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
