<?php

namespace Pepitelabs\PWS\EstimatingService;

/**
 * This class stands for WeightUnit EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: WeightUnit - enum
 * - nillable: true
 * - type: tns:WeightUnit
 * @subpackage Enumerations
 */
class WeightUnit
{
    /**
     * Constant for value 'lb'
     * Meta information extracted from the WSDL
     * - documentation: lb
     * @return string 'lb'
     */
    const VALUE_LB = 'lb';
    /**
     * Constant for value 'kg'
     * Meta information extracted from the WSDL
     * - documentation: kg
     * @return string 'kg'
     */
    const VALUE_KG = 'kg';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LB
     * @uses self::VALUE_KG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LB,
            self::VALUE_KG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
