<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShortAddress EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: ShortAddress
 * - nillable: true
 * - type: tns:ShortAddress
 * @subpackage Structs
 */
class ShortAddress extends AbstractStructBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City - string
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - documentation: Province - string
     * - nillable: true
     * @var string
     */
    public $Province;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: Country - string
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: PostalCode; - string
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for ShortAddress
     * @uses ShortAddress::setCity()
     * @uses ShortAddress::setProvince()
     * @uses ShortAddress::setCountry()
     * @uses ShortAddress::setPostalCode()
     * @param string $city
     * @param string $province
     * @param string $country
     * @param string $postalCode
     */
    public function __construct($city = null, $province = null, $country = null, $postalCode = null)
    {
        $this
            ->setCity($city)
            ->setProvince($province)
            ->setCountry($country)
            ->setPostalCode($postalCode);
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->Province;
    }
    /**
     * Set Province value
     * @param string $province
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        $this->Province = $province;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\ShortAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
