<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentEstimate EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: ShipmentEstimate
 * - nillable: true
 * - type: tns:ShipmentEstimate
 * @subpackage Structs
 */
class ShipmentEstimate extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: ServiceID - string
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - documentation: ShipmentDate - string
     * - nillable: true
     * @var string
     */
    public $ShipmentDate;
    /**
     * The ExpectedDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: ExpectedDeliveryDate - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpectedDeliveryDate;
    /**
     * The EstimatedTransitDays
     * Meta information extracted from the WSDL
     * - documentation: EstimatedTransitDays - int
     * - minOccurs: 0
     * @var int
     */
    public $EstimatedTransitDays;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - documentation: BasePrice - decimal
     * @var float
     */
    public $BasePrice;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - documentation: Surcharges - Surcharge[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge
     */
    public $Surcharges;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Taxes - Tax[]
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfTax
     */
    public $Taxes;
    /**
     * The OptionPrices
     * Meta information extracted from the WSDL
     * - documentation: OptionPrices - OptionPrice[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice
     */
    public $OptionPrices;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: TotalPrice - decimal
     * @var float
     */
    public $TotalPrice;
    /**
     * Constructor method for ShipmentEstimate
     * @uses ShipmentEstimate::setServiceID()
     * @uses ShipmentEstimate::setShipmentDate()
     * @uses ShipmentEstimate::setExpectedDeliveryDate()
     * @uses ShipmentEstimate::setEstimatedTransitDays()
     * @uses ShipmentEstimate::setBasePrice()
     * @uses ShipmentEstimate::setSurcharges()
     * @uses ShipmentEstimate::setTaxes()
     * @uses ShipmentEstimate::setOptionPrices()
     * @uses ShipmentEstimate::setTotalPrice()
     * @param string $serviceID
     * @param string $shipmentDate
     * @param string $expectedDeliveryDate
     * @param int $estimatedTransitDays
     * @param float $basePrice
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge $surcharges
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfTax $taxes
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice $optionPrices
     * @param float $totalPrice
     */
    public function __construct($serviceID = null, $shipmentDate = null, $expectedDeliveryDate = null, $estimatedTransitDays = null, $basePrice = null, \Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge $surcharges = null, \Pepitelabs\PWS\EstimatingService\ArrayOfTax $taxes = null, \Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice $optionPrices = null, $totalPrice = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setShipmentDate($shipmentDate)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setEstimatedTransitDays($estimatedTransitDays)
            ->setBasePrice($basePrice)
            ->setSurcharges($surcharges)
            ->setTaxes($taxes)
            ->setOptionPrices($optionPrices)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get ServiceID value
     * @return string|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get ExpectedDeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return isset($this->ExpectedDeliveryDate) ? $this->ExpectedDeliveryDate : null;
    }
    /**
     * Set ExpectedDeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expectedDeliveryDate
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        if (is_null($expectedDeliveryDate) || (is_array($expectedDeliveryDate) && empty($expectedDeliveryDate))) {
            unset($this->ExpectedDeliveryDate);
        } else {
            $this->ExpectedDeliveryDate = $expectedDeliveryDate;
        }
        return $this;
    }
    /**
     * Get EstimatedTransitDays value
     * @return int|null
     */
    public function getEstimatedTransitDays()
    {
        return $this->EstimatedTransitDays;
    }
    /**
     * Set EstimatedTransitDays value
     * @param int $estimatedTransitDays
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setEstimatedTransitDays($estimatedTransitDays = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedTransitDays) && !(is_int($estimatedTransitDays) || ctype_digit($estimatedTransitDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedTransitDays, true), gettype($estimatedTransitDays)), __LINE__);
        }
        $this->EstimatedTransitDays = $estimatedTransitDays;
        return $this;
    }
    /**
     * Get BasePrice value
     * @return float|null
     */
    public function getBasePrice()
    {
        return $this->BasePrice;
    }
    /**
     * Set BasePrice value
     * @param float $basePrice
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setBasePrice($basePrice = null)
    {
        // validation for constraint: float
        if (!is_null($basePrice) && !(is_float($basePrice) || is_numeric($basePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePrice, true), gettype($basePrice)), __LINE__);
        }
        $this->BasePrice = $basePrice;
        return $this;
    }
    /**
     * Get Surcharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge|null
     */
    public function getSurcharges()
    {
        return isset($this->Surcharges) ? $this->Surcharges : null;
    }
    /**
     * Set Surcharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge $surcharges
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setSurcharges(\Pepitelabs\PWS\EstimatingService\ArrayOfSurcharge $surcharges = null)
    {
        if (is_null($surcharges) || (is_array($surcharges) && empty($surcharges))) {
            unset($this->Surcharges);
        } else {
            $this->Surcharges = $surcharges;
        }
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfTax|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfTax $taxes
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setTaxes(\Pepitelabs\PWS\EstimatingService\ArrayOfTax $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get OptionPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice|null
     */
    public function getOptionPrices()
    {
        return isset($this->OptionPrices) ? $this->OptionPrices : null;
    }
    /**
     * Set OptionPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice $optionPrices
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setOptionPrices(\Pepitelabs\PWS\EstimatingService\ArrayOfOptionPrice $optionPrices = null)
    {
        if (is_null($optionPrices) || (is_array($optionPrices) && empty($optionPrices))) {
            unset($this->OptionPrices);
        } else {
            $this->OptionPrices = $optionPrices;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\ShipmentEstimate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
