<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: Shipment
 * - nillable: true
 * - type: tns:Shipment
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The SenderInformation
     * Meta information extracted from the WSDL
     * - documentation: SenderInformation - SenderInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\SenderInformation
     */
    public $SenderInformation;
    /**
     * The ReceiverInformation
     * Meta information extracted from the WSDL
     * - documentation: ReceiverInformation - ReceiverInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ReceiverInformation
     */
    public $ReceiverInformation;
    /**
     * The FromOnLabelIndicator
     * Meta information extracted from the WSDL
     * - documentation: FromOnLabelIndicator - bool
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FromOnLabelIndicator;
    /**
     * The FromOnLabelInformation
     * Meta information extracted from the WSDL
     * - documentation: FromOnLabelInformation - FromOnLabelInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\FromOnLabelInformation
     */
    public $FromOnLabelInformation;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - documentation: ShipmentDate - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentDate;
    /**
     * The PackageInformation
     * Meta information extracted from the WSDL
     * - documentation: PackageInformation - PackageInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PackageInformation
     */
    public $PackageInformation;
    /**
     * The InternationalInformation
     * Meta information extracted from the WSDL
     * - documentation: InternationalInformatio - InternationalInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\InternationalInformation
     */
    public $InternationalInformation;
    /**
     * The ReturnShipmentInformation
     * Meta information extracted from the WSDL
     * - documentation: ReturnShipmentInformation - ReturnShipmentInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation
     */
    public $ReturnShipmentInformation;
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - documentation: PaymentInformation - PaymentInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public $PaymentInformation;
    /**
     * The PickupInformation
     * Meta information extracted from the WSDL
     * - documentation: PickupInformation - PickupInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PickupInformation
     */
    public $PickupInformation;
    /**
     * The NotificationInformation
     * Meta information extracted from the WSDL
     * - documentation: NotificationInformation - NotificationInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\NotificationInformation
     */
    public $NotificationInformation;
    /**
     * The TrackingReferenceInformation
     * Meta information extracted from the WSDL
     * - documentation: TrackingReferenceInformation - TrackingReferenceInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation
     */
    public $TrackingReferenceInformation;
    /**
     * The OtherInformation
     * Meta information extracted from the WSDL
     * - documentation: OtherInformation - OtherInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\OtherInformation
     */
    public $OtherInformation;
    /**
     * The ProactiveNotification
     * Meta information extracted from the WSDL
     * - documentation: ProactiveNotificationInformation - ProactiveNotificationInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ProactiveNotification
     */
    public $ProactiveNotification;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setSenderInformation()
     * @uses Shipment::setReceiverInformation()
     * @uses Shipment::setFromOnLabelIndicator()
     * @uses Shipment::setFromOnLabelInformation()
     * @uses Shipment::setShipmentDate()
     * @uses Shipment::setPackageInformation()
     * @uses Shipment::setInternationalInformation()
     * @uses Shipment::setReturnShipmentInformation()
     * @uses Shipment::setPaymentInformation()
     * @uses Shipment::setPickupInformation()
     * @uses Shipment::setNotificationInformation()
     * @uses Shipment::setTrackingReferenceInformation()
     * @uses Shipment::setOtherInformation()
     * @uses Shipment::setProactiveNotification()
     * @param \Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation
     * @param \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation
     * @param bool $fromOnLabelIndicator
     * @param \Pepitelabs\PWS\EstimatingService\FromOnLabelInformation $fromOnLabelInformation
     * @param string $shipmentDate
     * @param \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation
     * @param \Pepitelabs\PWS\EstimatingService\InternationalInformation $internationalInformation
     * @param \Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation $returnShipmentInformation
     * @param \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation
     * @param \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation
     * @param \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation
     * @param \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation
     * @param \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation
     * @param \Pepitelabs\PWS\EstimatingService\ProactiveNotification $proactiveNotification
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation = null, \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation = null, $fromOnLabelIndicator = null, \Pepitelabs\PWS\EstimatingService\FromOnLabelInformation $fromOnLabelInformation = null, $shipmentDate = null, \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation = null, \Pepitelabs\PWS\EstimatingService\InternationalInformation $internationalInformation = null, \Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation $returnShipmentInformation = null, \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation = null, \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation = null, \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation = null, \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation = null, \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation = null, \Pepitelabs\PWS\EstimatingService\ProactiveNotification $proactiveNotification = null)
    {
        $this
            ->setSenderInformation($senderInformation)
            ->setReceiverInformation($receiverInformation)
            ->setFromOnLabelIndicator($fromOnLabelIndicator)
            ->setFromOnLabelInformation($fromOnLabelInformation)
            ->setShipmentDate($shipmentDate)
            ->setPackageInformation($packageInformation)
            ->setInternationalInformation($internationalInformation)
            ->setReturnShipmentInformation($returnShipmentInformation)
            ->setPaymentInformation($paymentInformation)
            ->setPickupInformation($pickupInformation)
            ->setNotificationInformation($notificationInformation)
            ->setTrackingReferenceInformation($trackingReferenceInformation)
            ->setOtherInformation($otherInformation)
            ->setProactiveNotification($proactiveNotification);
    }
    /**
     * Get SenderInformation value
     * @return \Pepitelabs\PWS\EstimatingService\SenderInformation|null
     */
    public function getSenderInformation()
    {
        return $this->SenderInformation;
    }
    /**
     * Set SenderInformation value
     * @param \Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setSenderInformation(\Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation = null)
    {
        $this->SenderInformation = $senderInformation;
        return $this;
    }
    /**
     * Get ReceiverInformation value
     * @return \Pepitelabs\PWS\EstimatingService\ReceiverInformation|null
     */
    public function getReceiverInformation()
    {
        return $this->ReceiverInformation;
    }
    /**
     * Set ReceiverInformation value
     * @param \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setReceiverInformation(\Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation = null)
    {
        $this->ReceiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get FromOnLabelIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFromOnLabelIndicator()
    {
        return isset($this->FromOnLabelIndicator) ? $this->FromOnLabelIndicator : null;
    }
    /**
     * Set FromOnLabelIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fromOnLabelIndicator
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setFromOnLabelIndicator($fromOnLabelIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromOnLabelIndicator) && !is_bool($fromOnLabelIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromOnLabelIndicator, true), gettype($fromOnLabelIndicator)), __LINE__);
        }
        if (is_null($fromOnLabelIndicator) || (is_array($fromOnLabelIndicator) && empty($fromOnLabelIndicator))) {
            unset($this->FromOnLabelIndicator);
        } else {
            $this->FromOnLabelIndicator = $fromOnLabelIndicator;
        }
        return $this;
    }
    /**
     * Get FromOnLabelInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\FromOnLabelInformation|null
     */
    public function getFromOnLabelInformation()
    {
        return isset($this->FromOnLabelInformation) ? $this->FromOnLabelInformation : null;
    }
    /**
     * Set FromOnLabelInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\FromOnLabelInformation $fromOnLabelInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setFromOnLabelInformation(\Pepitelabs\PWS\EstimatingService\FromOnLabelInformation $fromOnLabelInformation = null)
    {
        if (is_null($fromOnLabelInformation) || (is_array($fromOnLabelInformation) && empty($fromOnLabelInformation))) {
            unset($this->FromOnLabelInformation);
        } else {
            $this->FromOnLabelInformation = $fromOnLabelInformation;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDate
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get PackageInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PackageInformation|null
     */
    public function getPackageInformation()
    {
        return $this->PackageInformation;
    }
    /**
     * Set PackageInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setPackageInformation(\Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation = null)
    {
        $this->PackageInformation = $packageInformation;
        return $this;
    }
    /**
     * Get InternationalInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\InternationalInformation|null
     */
    public function getInternationalInformation()
    {
        return isset($this->InternationalInformation) ? $this->InternationalInformation : null;
    }
    /**
     * Set InternationalInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\InternationalInformation $internationalInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setInternationalInformation(\Pepitelabs\PWS\EstimatingService\InternationalInformation $internationalInformation = null)
    {
        if (is_null($internationalInformation) || (is_array($internationalInformation) && empty($internationalInformation))) {
            unset($this->InternationalInformation);
        } else {
            $this->InternationalInformation = $internationalInformation;
        }
        return $this;
    }
    /**
     * Get ReturnShipmentInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation|null
     */
    public function getReturnShipmentInformation()
    {
        return isset($this->ReturnShipmentInformation) ? $this->ReturnShipmentInformation : null;
    }
    /**
     * Set ReturnShipmentInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation $returnShipmentInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setReturnShipmentInformation(\Pepitelabs\PWS\EstimatingService\ReturnShipmentInformation $returnShipmentInformation = null)
    {
        if (is_null($returnShipmentInformation) || (is_array($returnShipmentInformation) && empty($returnShipmentInformation))) {
            unset($this->ReturnShipmentInformation);
        } else {
            $this->ReturnShipmentInformation = $returnShipmentInformation;
        }
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setPaymentInformation(\Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get PickupInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PickupInformation|null
     */
    public function getPickupInformation()
    {
        return $this->PickupInformation;
    }
    /**
     * Set PickupInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setPickupInformation(\Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation = null)
    {
        $this->PickupInformation = $pickupInformation;
        return $this;
    }
    /**
     * Get NotificationInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\NotificationInformation|null
     */
    public function getNotificationInformation()
    {
        return isset($this->NotificationInformation) ? $this->NotificationInformation : null;
    }
    /**
     * Set NotificationInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setNotificationInformation(\Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation = null)
    {
        if (is_null($notificationInformation) || (is_array($notificationInformation) && empty($notificationInformation))) {
            unset($this->NotificationInformation);
        } else {
            $this->NotificationInformation = $notificationInformation;
        }
        return $this;
    }
    /**
     * Get TrackingReferenceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation|null
     */
    public function getTrackingReferenceInformation()
    {
        return isset($this->TrackingReferenceInformation) ? $this->TrackingReferenceInformation : null;
    }
    /**
     * Set TrackingReferenceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setTrackingReferenceInformation(\Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation = null)
    {
        if (is_null($trackingReferenceInformation) || (is_array($trackingReferenceInformation) && empty($trackingReferenceInformation))) {
            unset($this->TrackingReferenceInformation);
        } else {
            $this->TrackingReferenceInformation = $trackingReferenceInformation;
        }
        return $this;
    }
    /**
     * Get OtherInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\OtherInformation|null
     */
    public function getOtherInformation()
    {
        return isset($this->OtherInformation) ? $this->OtherInformation : null;
    }
    /**
     * Set OtherInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setOtherInformation(\Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation = null)
    {
        if (is_null($otherInformation) || (is_array($otherInformation) && empty($otherInformation))) {
            unset($this->OtherInformation);
        } else {
            $this->OtherInformation = $otherInformation;
        }
        return $this;
    }
    /**
     * Get ProactiveNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\ProactiveNotification|null
     */
    public function getProactiveNotification()
    {
        return isset($this->ProactiveNotification) ? $this->ProactiveNotification : null;
    }
    /**
     * Set ProactiveNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\ProactiveNotification $proactiveNotification
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public function setProactiveNotification(\Pepitelabs\PWS\EstimatingService\ProactiveNotification $proactiveNotification = null)
    {
        if (is_null($proactiveNotification) || (is_array($proactiveNotification) && empty($proactiveNotification))) {
            unset($this->ProactiveNotification);
        } else {
            $this->ProactiveNotification = $proactiveNotification;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
