<?php

namespace Pepitelabs\PWS\EstimatingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnShipment EstimatingService
 * Meta information extracted from the WSDL
 * - documentation: Shipment
 * - nillable: true
 * - type: tns:ReturnShipment
 * @subpackage Structs
 */
class ReturnShipment extends AbstractStructBase
{
    /**
     * The SenderInformation
     * Meta information extracted from the WSDL
     * - documentation: SenderInformation - SenderInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\SenderInformation
     */
    public $SenderInformation;
    /**
     * The ReceiverInformation
     * Meta information extracted from the WSDL
     * - documentation: ReceiverInformation - ReceiverInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\ReceiverInformation
     */
    public $ReceiverInformation;
    /**
     * The PackageInformation
     * Meta information extracted from the WSDL
     * - documentation: PackageInformation - PackageInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PackageInformation
     */
    public $PackageInformation;
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - documentation: PaymentInformation - PaymentInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PaymentInformation
     */
    public $PaymentInformation;
    /**
     * The PickupInformation
     * Meta information extracted from the WSDL
     * - documentation: PickupInformation - PickupInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\PickupInformation
     */
    public $PickupInformation;
    /**
     * The NotificationInformation
     * Meta information extracted from the WSDL
     * - documentation: NotificationInformation - NotificationInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\NotificationInformation
     */
    public $NotificationInformation;
    /**
     * The TrackingReferenceInformation
     * Meta information extracted from the WSDL
     * - documentation: TrackingReferenceInformation - TrackingReferenceInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation
     */
    public $TrackingReferenceInformation;
    /**
     * The OtherInformation
     * Meta information extracted from the WSDL
     * - documentation: OtherInformation - OtherInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\EstimatingService\OtherInformation
     */
    public $OtherInformation;
    /**
     * Constructor method for ReturnShipment
     * @uses ReturnShipment::setSenderInformation()
     * @uses ReturnShipment::setReceiverInformation()
     * @uses ReturnShipment::setPackageInformation()
     * @uses ReturnShipment::setPaymentInformation()
     * @uses ReturnShipment::setPickupInformation()
     * @uses ReturnShipment::setNotificationInformation()
     * @uses ReturnShipment::setTrackingReferenceInformation()
     * @uses ReturnShipment::setOtherInformation()
     * @param \Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation
     * @param \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation
     * @param \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation
     * @param \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation
     * @param \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation
     * @param \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation
     * @param \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation
     * @param \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation
     */
    public function __construct(\Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation = null, \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation = null, \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation = null, \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation = null, \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation = null, \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation = null, \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation = null, \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation = null)
    {
        $this
            ->setSenderInformation($senderInformation)
            ->setReceiverInformation($receiverInformation)
            ->setPackageInformation($packageInformation)
            ->setPaymentInformation($paymentInformation)
            ->setPickupInformation($pickupInformation)
            ->setNotificationInformation($notificationInformation)
            ->setTrackingReferenceInformation($trackingReferenceInformation)
            ->setOtherInformation($otherInformation);
    }
    /**
     * Get SenderInformation value
     * @return \Pepitelabs\PWS\EstimatingService\SenderInformation|null
     */
    public function getSenderInformation()
    {
        return $this->SenderInformation;
    }
    /**
     * Set SenderInformation value
     * @param \Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setSenderInformation(\Pepitelabs\PWS\EstimatingService\SenderInformation $senderInformation = null)
    {
        $this->SenderInformation = $senderInformation;
        return $this;
    }
    /**
     * Get ReceiverInformation value
     * @return \Pepitelabs\PWS\EstimatingService\ReceiverInformation|null
     */
    public function getReceiverInformation()
    {
        return $this->ReceiverInformation;
    }
    /**
     * Set ReceiverInformation value
     * @param \Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setReceiverInformation(\Pepitelabs\PWS\EstimatingService\ReceiverInformation $receiverInformation = null)
    {
        $this->ReceiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get PackageInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PackageInformation|null
     */
    public function getPackageInformation()
    {
        return $this->PackageInformation;
    }
    /**
     * Set PackageInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setPackageInformation(\Pepitelabs\PWS\EstimatingService\PackageInformation $packageInformation = null)
    {
        $this->PackageInformation = $packageInformation;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PaymentInformation|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setPaymentInformation(\Pepitelabs\PWS\EstimatingService\PaymentInformation $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get PickupInformation value
     * @return \Pepitelabs\PWS\EstimatingService\PickupInformation|null
     */
    public function getPickupInformation()
    {
        return $this->PickupInformation;
    }
    /**
     * Set PickupInformation value
     * @param \Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setPickupInformation(\Pepitelabs\PWS\EstimatingService\PickupInformation $pickupInformation = null)
    {
        $this->PickupInformation = $pickupInformation;
        return $this;
    }
    /**
     * Get NotificationInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\NotificationInformation|null
     */
    public function getNotificationInformation()
    {
        return isset($this->NotificationInformation) ? $this->NotificationInformation : null;
    }
    /**
     * Set NotificationInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setNotificationInformation(\Pepitelabs\PWS\EstimatingService\NotificationInformation $notificationInformation = null)
    {
        if (is_null($notificationInformation) || (is_array($notificationInformation) && empty($notificationInformation))) {
            unset($this->NotificationInformation);
        } else {
            $this->NotificationInformation = $notificationInformation;
        }
        return $this;
    }
    /**
     * Get TrackingReferenceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation|null
     */
    public function getTrackingReferenceInformation()
    {
        return isset($this->TrackingReferenceInformation) ? $this->TrackingReferenceInformation : null;
    }
    /**
     * Set TrackingReferenceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setTrackingReferenceInformation(\Pepitelabs\PWS\EstimatingService\TrackingReferenceInformation $trackingReferenceInformation = null)
    {
        if (is_null($trackingReferenceInformation) || (is_array($trackingReferenceInformation) && empty($trackingReferenceInformation))) {
            unset($this->TrackingReferenceInformation);
        } else {
            $this->TrackingReferenceInformation = $trackingReferenceInformation;
        }
        return $this;
    }
    /**
     * Get OtherInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\EstimatingService\OtherInformation|null
     */
    public function getOtherInformation()
    {
        return isset($this->OtherInformation) ? $this->OtherInformation : null;
    }
    /**
     * Set OtherInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public function setOtherInformation(\Pepitelabs\PWS\EstimatingService\OtherInformation $otherInformation = null)
    {
        if (is_null($otherInformation) || (is_array($otherInformation) && empty($otherInformation))) {
            unset($this->OtherInformation);
        } else {
            $this->OtherInformation = $otherInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\EstimatingService\ReturnShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
